const express = require('express');
const app = express();
const bodyParser = require('body-parser');

const port = 3000;
const transactions = [];
let responseStatus = true;
app.use(bodyParser.urlencoded({ extended: true }));
app.listen(port, function () {
    console.log('App listening on port 3000!');
});

app.get('/', function (req, res) {
    res.sendFile(__dirname + '/index.html');
});

app.post('/', function (req, res) {
    if (Object.keys(req.body).length === 0) {
        res.status(400).send('Failed, request body is empty!');
    }
    const transactionExists = transactions.reduce((acc, trObj, i) => {
        if (acc) return acc;
        return trObj.transactionId === req.body.transactionId ? i : false;
    }, false);
    if (transactionExists) {
        transactions[transactionExists] = {
            ...transactions[transactionExists],
            updatedAt: Date.now(),
            status: responseStatus
        };
        console.log(transactions[transactionExists]);
        res.send(transactions[transactionExists]);
    } else {
        const newTransaction = {
            ...req.body,
            createdAt: Date.now(),
            updatedAt: Date.now(),
            status: responseStatus
        };
        transactions.push(newTransaction);
        console.log(newTransaction);
        res.send(newTransaction);
    }
});

app.get('/getTransactions', function (req, res) {
    res.json({ transactions });
});

app.get('/changeStatus', function (req, res) {
    responseStatus = !responseStatus;
    res.json({ responseStatus });
});