const express = require('express');
const app = express();
const bodyParser = require('body-parser');
const dbConfig = require('./config/db');
const MongoClient = require('mongodb').MongoClient;
const mongoose = require('mongoose');

const port = 3000;
const transactions = [];
let responseStatus = true;
app.use(bodyParser.urlencoded({ extended: true }));
app.listen(port, function () {
    console.log('App listening on port 3000!');
});

app.get('/', function (req, res) {
    // Transaction.find(function (err, transactions) {
    //     if (err) return console.error(err);
    //     console.log(transactions);
    // });

    res.sendFile(__dirname + '/index.html');
});

app.post('/', function (req, res) {
    if (Object.keys(req.body).length === 0) {
        res.status(400).send('Failed, request body is empty!');
    }
    // const { transctionId, amount, createdAt, updatedAt, status } = req.body;
    // const transaction = new Transaction({
    //     transctionId,
    //     amount,
    //     createdAt,
    //     updatedAt,
    //     status,
    // });
    // transaction.save(function (err, transaction) {
    //     if (err) return console.error(err);
    // });
    const transactionExists = transactions.reduce((acc, trObj, i) => {
        if (acc) return acc;
        return trObj.transactionId === req.body.transactionId ? i : false;
    }, false);
    if (transactionExists) {
        transactions[transactionExists] = {
            ...transactions[transactionExists],
            updatedAt: Date.now(),
            status: responseStatus
        };
        res.send(transactions[transactionExists]);
    } else {
        const newTransaction = {
            ...req.body,
            createdAt: Date.now(),
            updatedAt: Date.now(),
            status: responseStatus
        };
        transactions.push(newTransaction);
        res.send(newTransaction);
    }
});

app.get('/getTransactions', function (req, res) {
    res.json({ transactions });
});

app.get('/changeStatus', function (req, res) {
    responseStatus = !responseStatus;
    res.json({ responseStatus });
});

// mongoose.connect(dbConfig.url);

// const db = mongoose.connection;
// db.on('error', console.error.bind(console, 'connection error:'));
// db.once('open', function () {
//     console.log('Mongoose connection opened');
// });

// const transactionSchema = mongoose.Schema({
//     transctionId: String,
//     ammount: Number,
//     createdAt: Number,
//     updatedAt: Number,
//     status: Boolean,
// });

// const Transaction = mongoose.model('Transaction', transactionSchema);