// License: Apache 2.0. See LICENSE file in root directory.
// Copyright(c) 2015 Intel Corporation. All Rights Reserved.

//#include <face.h>

#include <librealsense/rs.hpp>
#include <opencv2/opencv.hpp>
//#include "opencv2/core/utility.hpp"
#include "opencv2/surface_matching.hpp"
#include "opencv2/surface_matching/ppf_helpers.hpp"
#include <opencv2/surface_matching/ppf_match_3d.hpp>
#include "face.h"

/*
#include "opencv2/objdetect/objdetect.hpp"
#include "opencv2/highgui/highgui.hpp"
#include "opencv2/imgproc/imgproc.hpp"

#include <chrono>
#include <vector>
#include <sstream>
#include <iostream>
#include <algorithm>*/

#include <unistd.h>
#include <stdio.h>

using namespace std;
using namespace cv;
using namespace ppf_match_3d;
using namespace FaceDetection;

string filename;

String face_cascade_name = "";
String eyes_cascade_name = "";
cv::CascadeClassifier face_cascade;
cv::CascadeClassifier eyes_cascade;

std::function<void(cv::Mat)> *faceFrameReadyCallback;
std::function<void(std::string)> *faceSaveCallback;
std::function<void(std::string, int)> *faceCheckCallback;

FaceDetection::Mode newMode;

bool started=false;

struct facePosition {int x, y, width, height; };

int Loop();

void FaceDetector::Init(string wd)
{
    face_cascade_name = wd + "/haarcascade_frontalface_alt.xml";
    eyes_cascade_name = wd + "/haarcascade_eye_tree_eyeglasses.xml";

    if( !face_cascade.load( face_cascade_name ) ){ printf("--(!)Error loading\n"); return; };
    printf("init\n");
}

///
/// \param faceCallback
void FaceDetector::Start(
        std::function<void(cv::Mat)>&& faceCallback,
        std::function<void(std::string)>&& saveCallback,
        std::function<void(std::string, int)>&& checkCallback)
{
    newMode = IDLE;

    faceSaveCallback = &saveCallback;
    faceCheckCallback = &checkCallback;

    faceFrameReadyCallback = &faceCallback;
    started = true;
    Loop();
}

///
///
void FaceDetector::Stop() {
    started=false;
}

///
/// \param filename
void FaceDetector::SaveFace(string file)
{
    filename = file;
    newMode = TRAIN;
}

///
/// \param filename
void FaceDetector::CheckFace(string file)
{
    filename = file;
    newMode = RECOGNIZE;
}


///
/// \param frame
/// \param facePos
/// \return
bool detectAndDisplay( Mat frame, facePosition &facePos ) {
    if (frame.empty())
        return false;

    std::vector<Rect> faces;
    Mat frame_gray;

    cvtColor(frame, frame_gray, CV_BGR2GRAY);
    equalizeHist(frame_gray, frame_gray);

    face_cascade.detectMultiScale(frame_gray, faces, 1.1, 2, 0 | CV_HAAR_SCALE_IMAGE, Size(180, 180));

    if (faces.size() > 0) {
        facePos.x = faces[0].x;
        facePos.y = faces[0].y;
        facePos.width = faces[0].width;
        facePos.height = faces[0].height;
        return true;
    }
    return false;
}

int Loop()
{
    try
    {
        newMode = IDLE;

        ppf_match_3d::PPF3DDetector detector(1.0 / 4.0, 0.05, 20);

        rs::context ctx;
        if (ctx.get_device_count() == 0) throw std::runtime_error("No device detected. Is it plugged in?");
        rs::device *device = ctx.get_device(0);

        device->enable_stream(rs::stream::depth, 640, 480, rs::format::z16, 30);//rs::preset::best_quality);
        device->enable_stream(rs::stream::color, 640, 480, rs::format::rgb8, 30);//rs::preset::best_quality);
        device->enable_stream(rs::stream::infrared, 640, 480, rs::format::y16, 30);//rs::preset::best_quality);
        device->start();
        int trainClock = 0;

        while (started)
        {
            FaceDetection::Mode currentMode = newMode;

            if (device->is_streaming())
                device->wait_for_frames();

            trainClock += 1;

            // Retrieve our images
            const uint16_t *depth_image = (const uint16_t *) device->get_frame_data(rs::stream::depth);
            const uint8_t *color_image = (const uint8_t *) device->get_frame_data(rs::stream::color);

            // Retrieve camera parameters for mapping between depth and color
            rs::intrinsics depth_intrin = device->get_stream_intrinsics(rs::stream::depth);
            rs::extrinsics depth_to_color = device->get_extrinsics(rs::stream::depth, rs::stream::color);
            rs::intrinsics color_intrin = device->get_stream_intrinsics(rs::stream::color);
            float scale = (device->get_depth_scale());

            bool faceDetected = false;
            /////////////////////////////////////////////////////////////////////////////////////////////
            facePosition facePos;
            if (trainClock % 5 == 0)
            {
                cv::Mat frame(color_intrin.height, color_intrin.width, CV_8UC3, (uchar *) color_image);
                if (detectAndDisplay(frame, facePos))
                {
                    faceDetected = true;
                }
            }

            if (!faceDetected)
                continue;

            cv::Mat protoModel(depth_intrin.width * depth_intrin.height, 6, CV_32F);
            /////////////////////////////////////////////////////////////////////////////////////////////

            int modelPointsCount = 0;
            for (int dy = 0; dy < depth_intrin.height; ++dy)
            {
                for (int dx = 0; dx < depth_intrin.width; ++dx)
                {
                    // Retrieve the 16-bit depth value and map it into a depth in meters
                    uint16_t depth_value = depth_image[dy * depth_intrin.width + dx];
                    float depth_in_meters = depth_value * scale;

                    // Skip over pixels with a depth value of zero, which is used to indicate no data
                    if (depth_value == 0) continue;

                    // Map from pixel coordinates in the depth image to pixel coordinates in the color image
                    rs::float2 depth_pixel = {(float) dx, (float) dy};
                    rs::float3 depth_point = depth_intrin.deproject(depth_pixel, depth_in_meters);
                    rs::float3 color_point = depth_to_color.transform(depth_point);
                    rs::float2 color_pixel = color_intrin.project(color_point);

                    // Use the color from the nearest color pixel, or pure white if this point falls outside the color image
                    const int cx = (int) std::round(color_pixel.x),
                            cy = (int) std::round(color_pixel.y);

                    float a = cx - (facePos.x + facePos.width / 2);
                    float b = cy - (facePos.y + facePos.height / 2);
                    float ry = (facePos.height / 2) * 0.9f;
                    float rx = (facePos.width / 2) * 0.7f;

                    bool insideEllipse = ((a * a) / (rx * rx) + (b * b) / (ry * ry)) <= 1;

                    if (insideEllipse)
                    {
                        protoModel.at<float>(modelPointsCount, 0) = depth_point.x;
                        protoModel.at<float>(modelPointsCount, 1) = depth_point.y;
                        protoModel.at<float>(modelPointsCount, 2) = depth_point.z;
                        protoModel.at<float>(modelPointsCount, 3) = 0;
                        protoModel.at<float>(modelPointsCount, 4) = 0;
                        protoModel.at<float>(modelPointsCount, 5) = 0;

                        modelPointsCount += 1;
                    }
                }
            }

            if (modelPointsCount == 0)
                continue;

            cv::Mat model(modelPointsCount, 6, CV_32F);

            for (int k = 0; k < modelPointsCount; k++)
            {
                model.at<float>(k, 0) = protoModel.at<float>(k, 0);
                model.at<float>(k, 1) = protoModel.at<float>(k, 1);
                model.at<float>(k, 2) = protoModel.at<float>(k, 2);
                model.at<float>(k, 3) = protoModel.at<float>(k, 3);
                model.at<float>(k, 4) = protoModel.at<float>(k, 4);
                model.at<float>(k, 5) = protoModel.at<float>(k, 5);
            }

            (*faceFrameReadyCallback)(model);

            switch (currentMode)
            {
                case IDLE:
                    //printf("idle");
                    break;
                case TRAIN:
                {

                    writePLY(model, filename.c_str());
                    printf("train switch, filename: %s\n",filename.c_str());
                    (*faceSaveCallback)(filename);
                    printf("callback fired");
                    newMode = IDLE;
                    /*printf("train\n");
                    detector.trainModel(model);
                    FileStorage fs("test7777777ss77.yml", FileStorage::WRITE);
                    detector.write(fs);*/

                    //looping = false;
                }
                    break;
                case RECOGNIZE:

                    Mat origin = loadPLYSimple(filename.c_str(), 1);

                    detector.trainModel(origin);

                    vector<Pose3DPtr> results;
                    detector.match(model, results);
                    trainClock = 1;
                    if (results.size() > 0)
                    {
                        (*faceCheckCallback)(filename, results[0]->numVotes);
                        newMode = IDLE;
                    }

                    break;
            }
        }

        device->stop();
        return 0;
    }

    catch (const rs::error &e)
    {
        std::cerr << "RealSense error calling " << e.get_failed_function() << "(" << e.get_failed_args() << "):\n    "
                  << e.what() << std::endl;
        return 0;
    }
    catch (const std::exception &e)
    {
        std::cerr << e.what() << std::endl;
        return 0;
    }
}