var map;


var pages = [].slice.call(document.querySelectorAll('.page'));
var menus = [].slice.call(document.querySelectorAll('.menu-item'));
var languages = [].slice.call(document.querySelectorAll('.language-switch'));

languages.forEach(function(lEl){
	lEl.addEventListener('click', function(){
		setLanguage(lEl.innerText);
	});
});
var currentLang = 'en', currentPage = 'service';
var setLanguage = function(lang){
	currentLang = lang;
	updateCls();

	[].slice.call(document.querySelectorAll('[data-t]')).forEach(function(el){
		var localizeString = el.getAttribute('data-t');
		var branch = locale[localizeString];
		if(!branch){
			return console.error('No translation for '+localizeString+'/'+lang)
		}
		el.innerText = locale[localizeString][lang];
	})
};
var updateCls = function(){
	document.body.className = currentLang + ' m-'+currentPage;
}
var activate = function(page){
	currentPage = page;
	updateCls();

	pages.forEach(function(page){
		page.classList.toggle('hidden', !page.classList.contains('page-'+currentPage));
	});
	if(currentPage === 'contact'){
		if(!map && window.DG){
			DG.then(function () {
				map = DG.map('map', {
					center: [55.777878, 37.672837],
					zoom: 15
				});

				DG.marker([55.777878, 37.672837]).addTo(map);
			});
		}
	}
};

var page = document.location.href.split('/').filter(String).pop().toLowerCase();
if(',contact,about,service,privacy,certificate,'.indexOf(','+page+',')>-1) {
	activate( page )
}else{
	activate(currentPage)
}

menus.forEach(function(item){
	item.addEventListener('click', function(e){
		e.preventDefault();
		e.stopPropagation();
		var itemName = this.getAttribute('data-t').split('.')[1];
		activate(itemName)
	});
});
(function(){
	var gl = document.querySelector('.gallery'), glS = gl.style, bW, bH;
	var rsz = function(){
		bW = document.body.clientWidth;
		bH = document.body.clientHeight;
	};
	document.body.addEventListener('resize', rsz);
	rsz();
	document.body.addEventListener('mousemove', function(e){
		glS.backgroundPosition = (128-e.clientX/bW*128|0)+'px '+ (-e.clientY/bH*256|0)+'px'
	});
})();
setLanguage(currentLang);