//import * as assert from 'assert';
const { Answer } = require("../Model/Event");

const {it, describe} = require('mocha');
const TelegramBot = require('./util/bot-mock');
const assert = require( "assert" );

describe('pattern matching', function (){
    const reply = function(tpl) {
        return function(msg) {
            debugger
            msg.reply((tpl||'')+msg.data)
        }
    };
    let bot;
    it( 'should create fake bot', function( done ){
        const token = '123';
        bot = new TelegramBot( token, {
            polling: true
        } );
        assert.strictEqual(bot.bot, void 0);
        done();
    });

    it( 'should init fake bot', function( done ){
        bot
            .behave( [
                Answer('/test', reply('simple:')),
                Answer('/test1', reply('simple:')),
                Answer('/test {{$something}}', reply('var:')),
            ] )
            .init();
        assert.notStrictEqual(bot.bot, void 0);

        done();
    });

    it( 'should match strict commands', function( done ){
        bot
            .test();


        done();
    } )
});
