const Event = function(cfg, then) {
    if(typeof cfg === 'function'){
        then = cfg;
        cfg = '{{$msg}}';
    }
    if(!cfg)
        return;
    this._match = cfg;
    this.buildRegExp();
    this._then = [];
    if(then)
        this.then(then);
};

const ReplyFactory = function(cfg, then) {
    return new Reply(cfg, then);
};

Event.prototype = {
    buildRegExp: function() {
        const regTokenNames = this.regTokenNames = [];
        this.matchRegExp = new RegExp(this._match.trim().replace(/\//g,'\\/').replace(/\{\{\$([^\}]*)\}\}/g, function(f,k){
            regTokenNames.push(k);
            return '(.*)'
        }), 'i');
    },
    then: function(resolve, reject) {
        this._then.push({resolve, reject});
        return this;
    },
    match: function(msg) {
        const matched = msg.raw.text.trim().match(this.matchRegExp)
        if(!matched)
            return false;

        const out = {},
            list = this.regTokenNames;
        for(let i = 0, _i = list.length; i < _i; i++){
            out[list[i]] = matched[i+1];
        }
        return out;
    },
    proceed: function(msg, match) {
        for( let i = 0, _i = this._then.length; i < _i; i++ ){
            const thenElement = this._then[ i ];
            thenElement.resolve.call(msg, msg, match);
        }
    }
};
const Reply = function(cfg, then) {
    Event.call(this, cfg, then);
};
Reply.prototype = new Event();
Reply.prototype.match = function(msg, then) {
    if(!('reply_to_message' in msg.raw))
        return false;
    return Event.prototype.match.call(this, msg, then);
};
ReplyFactory.cls = Reply;
const AnswerFactory = function(cfg, then) {
    return new Event(cfg, then);
};

module.exports = {Reply: ReplyFactory, Answer: AnswerFactory};
