var fs = require('fs');
var path = require('path');

const chatDataStorage = {};
const dir = path.join(__dirname, '../','tmp');

const getPath = function(name) {
    return path.join( dir, name.toString(10) );
};


var entries = fs.readdirSync( dir );
for( var i = 0; i < entries.length; i++ ){
    var entry = entries[i];

    var fullPath = getPath(entry);
    var stat = fs.statSync( fullPath );
    if( stat.isFile() && entry.charAt(0) !== '.' && entry.match(/[^\d\-]/) === null ){
        console.log(entry)
        try{
            var result = JSON.parse( fs.readFileSync( fullPath ) );
            chatDataStorage[entry] = result
        }catch( e ){
            console.log(e);
        }
    }
}

module.exports = {
    save: function(id, data) {
        try{
            chatDataStorage[id] = data;
            fs.writeFile( getPath( id ), JSON.stringify( data, null, 2 ), function(err, data) {

            } )
        }catch(e){
            console.log(e);
        }
    },
    load: function(id) {
        if(!(id in chatDataStorage))
            return {};
        else
            return chatDataStorage[id];
    }
};