const Message = require('../Model/Message');

const Bot = function(token, cfg) {
    this.token = token;
    this.cfg = cfg;
};

Bot.prototype = {
    behave: function(rules) {
        this.rules = rules;
        return this;
    },
    _createBot: function(token, cfg) {
        const TelegramBot = require('node-telegram-bot-api');
        return new TelegramBot(token, cfg)
    },
    init: function() {
        const {token, cfg} = this;
        const bot = this.bot = this._createBot(token, cfg);

        const captured = require('../Model/User').captured;

        bot.on('message', (msg) => {
            const wrappedMessage = new Message(msg, bot);
            const rules = this.rules;
            if(captured(wrappedMessage))
                return;

            for( let i = 0, _i = rules.length; i < _i; i++ ){
                const rule = rules[ i ], match = rule.match(wrappedMessage);
                if(match){
                    rule.proceed(wrappedMessage, match);
                    break;
                }
            }
        });

        const callbackResolver = require('../Model/Choose').resolver;
        bot.on('callback_query', function (msg) {
            const wrappedMessage = new Message(msg, bot);
            callbackResolver(wrappedMessage);
        });
        return this;
    }
};
module.exports = Bot;