const {Reply, Answer} = require('./Model/Event'),
    {Choose} = require('./Model/Choose'),
      L = require('localize.js')('ru', require('./locale/locale.ru'));

const maxWarns = 3;
module.exports = [
    Answer('/test {{$string}}', function(msg, match) {
        var tmp = L.L.variableResolveFailed;
        L.L.variableResolveFailed = function(varName) {
            return '${'+varName+'}';
        };
        msg.reply(
            'Template: '+L.voc[match.string]+'\n'+
            'Result: '+L(match.string, {...msg.chat, ...msg.user})
        );
        L.L.variableResolveFailed = tmp;

    }),
    Answer('/help', function(message) {
        message.send(
            'List of commands:\n'+
            module.exports.map((item)=>'  '+(item instanceof Reply.cls?'>':'  ')+item._match).join('\n')
        );
    }),
    Reply('/warn')
        .then((message)=>{
            let warns = message.from.user.get('warns')|0;
            warns++;
            message.from.user.set({warns: warns});

            if(warns>=maxWarns){
                message.from.user.ban('60d');
                message.reply(L('ban', {...message.from.user}))
            }else{
                message.reply(L('warn', {
                    maxWarns: maxWarns,
                    count: warns,
                    diff: maxWarns-warns,
                    ...message.from.user
                }))
            }
        }),
    Reply('/ban')
        .then((message)=>{

            message.from.reply(L('ban', {...message.from.user}));
            message.from.user.ban();
        }),
    Reply('/unban')
        .then((message)=>{
            message.from.user.unban();
            //message.from.user.send(L('unbanGreeting', {...message.chat}));
            message.reply(L('unban', {...message.from.user}))
        }),
    Reply('/reply')
        .then( (msg)=>{
            msg.send('Команда /reply пожрона');
            msg.from.reply('Реплай на реплай');
        }),

    Reply('/test1')
        .then((message)=>{
            message.remove();
            message.reply('Ti pidor')
        }),

    Answer('/say {{$kokoko}}')
        .then((message, match)=>{
            message.send(match.kokoko)
        }),

    Answer('/reply {{$text}}')
        .then((msg, match)=>{
            msg.send('Preparing to /reply');
            msg.reply(match.text);
        }),
    Reply('/count {{$to}}', async function( message, match ){
        if( (await message.user.isAdmin()) && !(await message.from.user.isAdmin())){
            message.reply(L('permission'))
            var usr = message.from.user;
            var isPazak = ( usr.id % 2 ) === 0;
            //var chatlanPlanet = isPazak;
            var countTo = (match.to|0)||3;
            message.from.send(L('pidor', {count: countTo, condition: isPazak, ...usr}));
            var last = 1;
            var mistakes = 0;
            var debil = 0;
            var capture = message.from.user.capture( [
                Answer('{{$any}}', (msg, match)=>{
                    var matched = match.any.match(/(\d+)/);
                    var matchedKU = match.any.match(/ку/i) !== null || match.any.match(/ыыы/i) !== null;
                    if(!matched && matchedKU){
                        // можно говорить "КУ" и "ЫЫЫ"
                        Math.random()>0.5 && msg.reply( L( 'pidorKletka' ) );
                    }else{
                        if( !matched ){
                            mistakes++;
                            if( mistakes <= 5 ){
                                msg.reply( L( 'pidorDoNotCount' + mistakes ) )
                            }else{
                                msg.reply( L( 'pidorDoigralsa' ) );
                                msg.user.ban();
                                capture.stop();
                            }
                        }else{
                            var num = parseInt( matched[ 0 ], 10 );
                            if( num === last ){
                                last++;
                                if(last % 3 === 0){
                                    msg.reply( L( 'pidorKU' ) );
                                }
                                if(countTo === last - 1){
                                    msg.reply( L( 'pidorOK' ) );
                                    msg.reply( L( 'pidorKU' ) );
                                    capture.stop();
                                }
                            }else{
                                debil++;
                                if(debil<3 || last === 1){
                                    msg.reply( L( 'pidorCanNotCount' ) );
                                }else{
                                    msg.reply( L( 'pidorCanNotCount2' ) );
                                    last = 1;
                                }
                            }
                        }
                    }
                })
            ] );
        }
    }),

    Answer('/counter', async function( message ){

        console.log( message.user.full_name + ' isAdmin:' + ( await message.user.isAdmin() ? 'true' : 'false' ) );
        console.log( 1 );
        for( let i = 0; i < 10; i++ )
            setTimeout( () => message.send( i ), i * 1000 )
    }),

    Answer('/newPattern',function(message) {
        message.reply(L('newLocale'));
        const originalChat = message.user.chat.id;
        message.user.chat.id = message.user.id;

        var capture = message.user.capture( [
                Answer('{{$any}}', function(msg, match) {
                    capture.stop();
                    msg.send(L('linkToUI', {link: 'http://lal.ru'}))
                })
            ]);

        setTimeout(()=>capture.stop(), 5*60*1000);
        /*
            .send('Which pattern?', Choose([
                { text: 'Read only'},
                { text: 'Text only'},
                { text: 'Timeout kick'},
            ], function(result) {
                message.user.send('Selected: '+result.text);
            }));*/
    })
];