Implemented Abstractions:
### Chat
##### props
  `id<int>`

### User
##### props
  `id<int>`
  
  `chat<Chat>`
  
  `isAdmin<bool>` — return true if user is admin of the group

##### methods
  `send(text: string, [Choose])` — send PM to user. Really it is not useful due to bot can not initiate chat with user
  
  `ban(duration: string)` — ban user in group
  
  `unban()` — unban user. this would not read user to the group (bot api does not support this action)
  
  `capture(Event[]): <CaptureStop>` — capture all next users messages in the messages group and begin to match them only against specified `Event list`

### Message
##### props
  `raw` — original data from API
  
  `raw.message_id<int>`
  
  `user<User>`
  
  `chat<Chat>`
  
  `from<Message>` — if message is a reply — it would contains previous message. TODO: rename it

##### methods
  `send(text: string)` — send new message to the messages channel
  `reply(text: string)` — send reply to the message
  `remove()` — remove message from channel

### Choose
 > abstraction for generating custom in-chat-buttons

TODO: refactor code to standalone module.

Example of rules:
```js
// Admin can ban user by replying to his\her massage with `\ban`. Works only if user is not admin.
Reply('/ban')
    .then(async function( message ){
        if( (await message.user.isAdmin()) && !(await message.from.user.isAdmin())){
          message.from.reply(L('ban', {...message.from.user}));
          message.from.user.ban();
        }
    })
Answer('/say {{$kokoko}}')
    .then((message, match)=>{
        message.send(match.kokoko)
    })
```
