const ms = require('ms');
const User = function(userData, chat, msg) {
        Object.assign(this, userData);
        this.raw = userData;
        this.chat = chat;
        this.data = chat.getUserData(this);
        this.msg = msg;
        this.full_name = this.first_name+' '+this.last_name;
    };

UserFactory = function(cfg, cfg2, msg) {
        return new User(cfg, cfg2, msg);
    };

User.prototype = {
    isAdmin: async function() {
        var admins = await this.msg.bot.getChatAdministrators(this.chat.id);
        var admin = admins.filter((item)=>item.user.id === this.id);

        return admin.length ? admin[0] : false;
    },
    ban: function(duration) {
        this.msg.bot.kickChatMember(this.chat.id, this.id, {
            until_date: Date.now() + ms(duration || '60d'),
        });
    },
    unban: function() {
        this.msg.bot.unbanChatMember(this.chat.id, this.id);

    },
    get: function(key) {
        return this.data[key];
    },
    set: function(cfg) {
        for(let key in cfg){
            this.data[key] = cfg[key];
        }
        this.chat.setUserData(this);
    },
    send: function(text, opts) {
        this.msg.bot.sendMessage(this.id, text, opts);
    },
    capture: function(arr) {
        const capture = {
            chat: this.chat.id,
            user: this.id,
            arr: arr
        };
        const chat = captures[this.chat.id] || (captures[this.chat.id] = {});
        (chat[this.id] || (chat[this.id] = [])).push(capture);
        let stopped = false;
        return {
            stop: function() {
                if(stopped)
                    return;
                stopped = true;
                chat[capture.user].splice(chat[capture.user].indexOf(capture), 1);
                if(chat[capture.user].length === 0){
                    delete chat[ capture.user ];
                }
                if(Object.keys(chat).length === 0){
                    delete captures[capture.chat];
                }
            }
        };
    }
};

const captures = {};

UserFactory.captured = function(msg) {
    if(msg.chat.id in captures){
        const chat = captures[msg.chat.id];
        if(msg.user.id in chat){
            const capture = chat[msg.user.id];
            const rules = capture[capture.length - 1].arr; // LIFO

            for( let i = 0, _i = rules.length; i < _i; i++ ){
                const rule = rules[ i ], match = rule.match(msg);
                if(match){
                    rule.proceed(msg, match);
                    break;
                }
            }
            return true;
        }
    }
    return false;
};

module.exports = UserFactory;
