const User = require('./User'),
    Chat = require('./Chat');

const Message = function(msg, bot) {
        this.raw = msg;
        this.bot = bot;
    };

MessageFactory = function(msg, bot) {
        return new Message(msg, bot);
    };

Message.prototype = {
    getUser: function() {
        return this._user || (this._user = new User(this.raw.from, this.getChat(), this))
    },
    getChat: function() {
        return this._chat || (this._chat = new Chat(this.raw.chat))
    },
    getFrom: function() {
        if(!('reply_to_message' in this.raw)){
            throw new Error('Message is not a reply:\n'+JSON.stringify(this.raw,null,2))
        }
        return this._from || (this._from = new Message(this.raw.reply_to_message, this.bot))
    },
    remove: function() {
        return this.bot.deleteMessage(this.chat.id, this.raw.message_id);
    },
    send: function(text) {
        this.bot.sendMessage(this.chat.id, text);
    },
    reply: function(text) {
        this.bot.sendMessage(this.chat.id, text, {reply_to_message_id: this.raw.message_id});
    }
};
Object.defineProperty(Message.prototype, 'user', {get: function() {
    return this.getUser();
}});
Object.defineProperty(Message.prototype, 'chat', {get: function() {
    return this.getChat();
}});
Object.defineProperty(Message.prototype, 'from', {get: function() {
    return this.getFrom();
}});
module.exports = MessageFactory;
