'use strict';
const async = require('async');
var dbm;
var type;
var seed;

/**
  * We receive the dbmigrate dependency from dbmigrate initially.
  * This enables us to not have to rely on NODE_PATH.
  */
exports.setup = function(options, seedLink) {
  dbm = options.dbmigrate;
  type = dbm.dataType;
  seed = seedLink;
};

exports.up = function(db, callback){


  const locale = require( '../locale/locale.ru' );
  const queries = [
    db.createTable.bind( db, 'chat', {
      columns: {
        id: {
          type: 'bigint',
          primaryKey: true
        }
      },
      ifNotExists: true
    } ),
    db.createTable.bind( db, 'chat', {
      columns: {
        id: {
          type: 'bigint',
          primaryKey: true
        }
      },
      ifNotExists: true
    } ),
    db.createTable.bind( db, 'user', {
      columns: {
        userID: {
          type: 'bigint'
        },

        chatID: {
          type: 'bigint'
        },
        data: {
          type: 'string'
        }
      },
      ifNotExists: true
    } ),
    db.addIndex.bind( db, 'user', 'user_chat', [ 'chatID', 'userID' ], true ),
    db.createTable.bind( db, 'locale', {
      columns: {
        k: { type: 'string' },
        v: { type: 'string' }
      },
      ifNotExists: true
    } )
  ];
  for(const k in locale){
    queries.push(db.insert.bind(db,'locale', ['k', 'v'], [k, locale[k]]));
  }
  return async.series(queries, callback)

};

exports.down = function(db, callback) {
  db.dropTable('chat', function(err) {
    if (err) { callback(err); return; }
    db.dropTable('user', function(err) {
      if (err) { callback(err); return; }
      db.removeIndex('user', 'user_chat', function(err) {
        if (err) { callback(err); return; }
        db.dropTable('locale', function(err) {
          if (err) { callback(err); return; }
          callback();
        })
      })

    })
  });
};

exports._meta = {
  "version": 1
};
