const rules = require('./rules');
const Message = require('./Model/Message');

const TelegramBot = require('node-telegram-bot-api');

// replace the value below with the Telegram token you receive from @BotFather
const token = process.env.token;

// Create a bot that uses 'polling' to fetch new updates
const bot = new TelegramBot(token, {
    polling: true
});


const captured = require('./Model/User').captured;
// Listen for any kind of message. There are different kinds of
// messages.
bot.on('message', (msg) => {
    const wrappedMessage = new Message(msg, bot);
    if(captured(wrappedMessage))
        return;

    for( let i = 0, _i = rules.length; i < _i; i++ ){
        const rule = rules[ i ], match = rule.match(wrappedMessage);
        if(match){
            rule.proceed(wrappedMessage, match);
            break;
        }
    }
});

const callbackResolver = require('./Model/Choose').resolver;
bot.on('callback_query', function (msg) {
    const wrappedMessage = new Message(msg, bot);
    callbackResolver(wrappedMessage);
});