import React, {KeyboardEvent, ChangeEvent} from "react";
import {Button, Grid, TextField} from "@material-ui/core";
import {addLocaleTemplate} from "../action-reducers/addLocaleTemplate";
import {getUUID} from "../helpers";

export interface INewLocaleTemplate {
    id: string
}

class NewLocaleTemplateView extends React.Component<INewLocaleTemplate, {}> {
    state = {
        expanded: false,
        text: '',
        invalid: false
    };

    addAction() {
        const text = this.state.text.trim();
        if(text.length > 0) {
            addLocaleTemplate({id: this.props.id, template: {uuid: getUUID(), text: text, enabled: true}});
            this.setState({expanded: false, text: ''})
        }else{
            this.setState({invalid: true})
        }
    }

    render(): React.ReactNode {
        const {invalid} = this.state;
        return <div>
            {this.state.expanded ?
                <div>
                    <TextField
                        error={invalid}
                        value={this.state.text}
                        onKeyDown={(e: KeyboardEvent) => {
                            if(e.key === 'Enter' && e.ctrlKey) {
                                this.addAction();
                            }
                            if(invalid)
                                this.setState({invalid: false});
                        }}
                        onChange={(e: ChangeEvent) => this.setState({text: (e.target as HTMLInputElement).value})}
                        margin="normal"
                        fullWidth
                        placeholder={'Шаблон вводить сюда'}
                        inputProps={{'aria-label': 'bare'}}
                    />
                    <Grid spacing={1} container>

                        <Grid item>
                            <Button variant="contained" color="secondary" onClick={() => this.addAction()}>
                                + Сохранить (Ctrl+enter)
                            </Button>
                        </Grid>
                        <Grid item>
                            <Button variant="contained" color="primary"
                                    onClick={() => this.setState({expanded: false})}>– Передумал</Button>
                        </Grid>
                    </Grid>
                </div>
                :
                <Button variant="contained" color="secondary" onClick={() => this.setState({expanded: true})}>
                    + Новый шаблон
                </Button>
            }
        </div>;
    }
}


export const NewLocaleTemplate = NewLocaleTemplateView;