import React from "react";
import {setActiveMenu} from "../action-reducers/setActiveMenu";
import {List, ListItem, ListItemText} from "@material-ui/core";
import {mainMenu} from "../model/mainMenu";

export class MainAsideMenu extends React.Component<{}, {}> {
    render(): React.ReactNode {
        const {activeMenu} = this.state;

        return <List>
            {mainMenu.map((item) => (
                <ListItem button selected={(activeMenu === item.id)} key={item.id} onClick={() => setActiveMenu(item.id)}>
                <ListItemText color={(activeMenu === item.id) ? "primary" : "secondary"} primary={item.text}/>
                </ListItem>
            ))}
        </List>;
    }
}