// src/js/reducers/index.js
import {mainMenu} from "../model/mainMenu";

export interface IMainStorage {
    activeMenu: string,
    locale: {
        //string: string
    },
    chatData: {

    }
}
const initialState: IMainStorage = {
    activeMenu: mainMenu.filter((el)=>el.active)[0].id,
    locale: {

    },
    chatData: {

    }
};

const reducers: any = {};

export const Action = function (type: string, reducer: Function<IMainStorage,IAction>) {
    reducers[type] = reducer;
    return function(payload: any){
        return {type, payload};
    }
};

export interface IAction {
    type: string,
    payload: any
};

function rootReducer(state:IMainStorage = initialState, action: IAction) {
    if(action.type in reducers){
        reducers[action.type](state, action)
    }else{
        throw new Error('No reducer for type `'+ action.type +'`')
    }
    return state;
}

export default rootReducer;