import React from "react";
import {connect} from "react-redux";
import {IMainStorage} from "../action-reducers";
import {
    Warning,
    Delete,
    SvgIconComponent,
    HotTub,
    AccessibleForward,
    FilterList,
    Code,
    CloudQueue, Build,
    Storage, Language
} from '@material-ui/icons';

import {Box, Container, Link, List, ListItem, ListItemIcon, ListItemText, Typography} from "@material-ui/core";

export interface IListItem {
    text: string,
    icon: SvgIconComponent,
    comment ?: string,
    link ?: string
}
const doList = (arr: IListItem[])=><List dense={true}>
    {arr.map((item, i)=>{
        const Icon = item.icon;
        return <ListItem key={i}>
            <ListItemIcon>
                <Icon/>
            </ListItemIcon>
            <ListItemText>
                {item.link?<Link href={item.link} color="secondary">{item.text}</Link>:item.text}
                {item.comment? <Typography display="inline" color="textSecondary">&nbsp;{item.comment}</Typography>:''}
            </ListItemText>
        </ListItem>
    })}
    </List>;
class InfoView extends React.Component<{}, {}> {
    render(): React.ReactNode {
        return <Container>
            <Typography variant="h4" gutterBottom>Информация о боте, его умениях и остальном</Typography>

            <Typography variant="subtitle1">Telegram Bot со стандартным функционалом:</Typography>
            {doList([
                {text: 'фильтрация контента', icon: FilterList},
                {text: 'предупреждения', icon: Warning},
                {text: 'бан', icon: Delete}
            ])}

            <Typography variant="subtitle1">Нестандартным:</Typography>
            {doList([
                {text: 'чмырение', icon: AccessibleForward},
                {text: 'расширение лексикона', icon: HotTub}
            ])}

            <Box mt={4}>
                <Typography variant="subtitle2" gutterBottom>Причина создания</Typography>
                <Typography variant="caption">Тёркин захотел бота для увеселения кипрского комьюнити тестировщиков,
                    я поддурился потому что давно хотел поиграться с tg-bot-api и всё не было повода.</Typography>
            </Box>

            <Box mt={4}>
                <Typography variant="subtitle2" gutterBottom>Stack:</Typography>
                {doList([
                    {text: 'Node.js', icon: Code, comment: '>= 8.7.0', link: 'https://nodejs.org/'},
                    {text: 'Typescript', icon: Code, link: 'https://www.typescriptlang.org/'},
                    {text: 'localize.js', icon: Language, link: 'https://www.npmjs.com/package/localize.js'},
                    {text: 'React', icon: Code, link: 'https://reactjs.org/'},
                    {text: 'Redux', icon: Code, link: 'https://redux.js.org/'},
                    {text: 'Redux-thunk', icon: Code, link: 'https://github.com/reduxjs/redux-thunk'},
                    {text: 'Material-ui', icon: Code, link: 'https://material-ui.com/'},
                    {text: 'Material-ui-icons', icon: Code, link: 'https://material-ui.com/components/material-icons/'},
                    {text: 'Maria DB', icon: Storage, link: 'https://mariadb.org/'},
                    {text: 'db-migrate', icon: Storage, comment: '— использовать базу в 2k19 без миграций запрещено', link: 'https://db-migrate.readthedocs.io/en/latest/'},
                    {text: 'Telegram Bot API', icon: CloudQueue, link: 'https://core.telegram.org/bots/api'},

                    {text: 'Yarn', icon: Build, link: 'https://yarnpkg.com/'},
                    {text: 'Webpack', icon: Build, link: 'https://webpack.js.org/'}

                ])}
            </Box>
        </Container>;
    }
}


export const Info = InfoView;