import {Constants} from "../view/Constants";
import React from "react";
import {Profile} from "../view/Profile";
import {Info} from "../view/Info";
import {setActiveMenu} from "../action-reducers/setActiveMenu";


import {AccountCircle, Help, HotTub} from '@material-ui/icons';
import {SvgIconComponent} from "@material-ui/icons";

export interface IComponentLambda {
    (): React.ComponentClass
}
export interface menuItem {
    id: string,
    text: string,
    active ?: boolean,
    view: IComponentLambda,
    icon: SvgIconComponent
}


export const mainMenu: menuItem[] = [
    {
        id: 'constants',
        text: 'Constants',
        active: true,
        view: ()=>Constants,
        icon: HotTub
    },
    {
        id: 'profile',
        text: 'Profile',
        active: true,
        view: ()=>Profile,
        icon: AccountCircle
    },
    {
        id: 'info',
        text: 'Info',
        view: ()=>Info,
        icon: Help
    }
];

setActiveMenu(mainMenu.filter((el)=>el.active)[0].id)
