import React from "react";
import {ILocale} from "../action-reducers";
import {
    List,
    ListItem,
    ListItemText,
    Collapse,
    Switch,
    ListItemSecondaryAction
} from "@material-ui/core";
import {NewLocaleTemplate} from "./NewLocaleTemplate";

import ExpandLess from '@material-ui/icons/ExpandLess';
import ExpandMore from '@material-ui/icons/ExpandMore';
import {toggleConstant} from "../action-reducers/toggleConstant";
import {toggleTemplate} from "../action-reducers/toggleTemplate";

export interface IConstant {
    item: ILocale
}

class ConstantView extends React.Component<IConstant, IConstant> {
    render(): React.ReactNode {
        const {id, values, collapsed} = this.props.item;
        return [<ListItem button onClick={()=>toggleConstant(id)} key={id+'-list'}>
                <ListItemText primary={id} />
                {!collapsed ? <ExpandLess /> : <ExpandMore />}
            </ListItem>,
            <Collapse in={!collapsed} timeout="auto" unmountOnExit key={id+'-collapse'}>
                <List component="div" disablePadding>
                    {values.map((val)=>{
                        return <ListItem key={val.uuid} >

                            {/*<TextField
                                value={val.text}
                                margin="normal"
                                inputProps={{ 'aria-label': 'bare' }}
                            />*/}
                            <ListItemText id="switch-list-label-wifi" primary={val.text} />
                            <ListItemSecondaryAction>
                                <Switch
                                    edge="end"
                                    onChange={()=>toggleTemplate({id: id, uuid: val.uuid})}
                                    checked={val.enabled}
                                />
                            </ListItemSecondaryAction>
                        </ListItem>}
                    )}
                    <NewLocaleTemplate id={id}/>
                </List>
            </Collapse>];





    }
}
/*const mapConstant = (store: IMainStorage): ILocale =>*/

export const Constant = /*connect(mapConstant)(*/ConstantView/*)*/;
