import {Action, IMainStorage} from './index';

export interface IToggleTemplate {
    payload: {
        id: string,
        uuid: string
    }
}


export const toggleTemplate = Action('TOGGLE_TEMPLATE', function (state: IMainStorage, {payload}: IToggleTemplate) {
    if(!(payload.id in state.locale)) {
        console.error('No such constant id', payload.id);

        return state;
    } else {
        const tpl = state.locale[payload.id];

        const newState = {
            ...state, locale: {
                ...state.locale,
                [payload.id]: {
                    ...tpl,
                    values: tpl.values.map((el)=>el.uuid === payload.uuid ? {...el, enabled: !el.enabled} : el)
                }
            }
        };

        return newState;
    }
});