import {Action, IMainStorage} from './index';

export interface IToggleConstant {
    payload: string
}


export const toggleConstant = Action('TOGGLE_CONSTANT', function (state: IMainStorage, {payload}: IToggleConstant) {
    const id = payload;
    if(!(id in state.locale)) {
        return state;
    } else {
        const tpl = state.locale[id];

        return {
            ...state, locale: {
                ...state.locale,
                [id]: {
                    ...tpl,
                    collapsed: !tpl.collapsed
                }
            }
        };
    }
});