// src/js/reducers/index.js
import store from "../store";
export interface ILocaleTemplate {
    uuid: string,
    text: string,
    enabled: boolean
}
export interface ILocale {
    id: string,
    collapsed: boolean,
    values: ILocaleTemplate[]
}

export interface ILocaleHash {
    [key: string]: ILocale
}

export interface IMainStorage {
    activeMenu: string,
    locale: ILocaleHash,
    chatData: {

    }
}
const initialState: IMainStorage = {
    activeMenu: 'main',
    locale: {

    },
    chatData: {

    }
};

const reducers: any = {};

export interface IReducer {
    (state: IMainStorage, action: IAction): IMainStorage;
}


export const Action = function (type: string, reducer: IReducer) {
    reducers[type] = reducer;
    return function(payload: any){
        return store.dispatch({type, payload});
    }
};

export interface IAction {
    type: string,
    payload: any
}

function rootReducer(state:IMainStorage = initialState, action: IAction) {
    if(action.type in reducers){
        return reducers[action.type](state, action)
    }else{
        console.warn('No reducer for type `'+ action.type +'`')
    }
    return state;
}

export default rootReducer;

