import React from 'react';
import Container from '@material-ui/core/Container';
import Typography from '@material-ui/core/Typography';
import Box from '@material-ui/core/Box';
import Button from '@material-ui/core/Button';
import Link from '@material-ui/core/Link';
import ProTip from './ProTip';
import List from "@material-ui/core/List";
import ListItem from "@material-ui/core/ListItem";
import ListItemText from "@material-ui/core/ListItemText";
import {Grid} from "@material-ui/core";


function MadeWithLove() {
  return (
    <Typography variant="body2" color="textSecondary" align="right">
      {'Built with love by the '}
      <Link color="inherit" href="https://material-ui.com/">
        Material-UI
      </Link>
      {' team.'}
    </Typography>
  );
}

export interface HelloProps { selectedIndex?: number}

export class App extends React.Component<HelloProps, {}> {
  state = {
    selectedIndex: 0
  };
  render() {
    const {selectedIndex} = this.state;
    return (
      <Container maxWidth="xl">
        <Grid container direction="row" justify="flex-start" alignItems="stretch">
          <Box my={4}>
            <List>
              {['Profile', 'Constants'].map((text, index) => (
                <ListItem button selected={(selectedIndex === index)} key={text}
                          onClick={() => this.setState({selectedIndex: index})}>
                  <ListItemText color={index % 2 ? "primary" : "secondary"} primary={text}/>
                </ListItem>
              ))}
            </List>
          </Box>
          <Box my={4}>
            <Typography variant="h4" component="h1" gutterBottom>
              Create React App v4-beta example with TypeScript
            </Typography>
            <ProTip/>

            <MadeWithLove/>
            <Button variant="contained">12345</Button>
            <Button variant="contained" color="primary">12345</Button>
            <Button variant="contained" color="secondary">12345</Button>
          </Box>
        </Grid>
      </Container>
    );
  }
};
