import React from "react";
import {connect} from "react-redux";
import {ILocaleHash, IMainStorage} from "../action-reducers";
import {AZ} from "../helpers";
import {Constant} from "../component/Constant";
import {Button, Container, List, ListItem, ListSubheader, TextField} from "@material-ui/core";
import {NewLocale} from "../component/NewLocale";

export interface IConstants {
    locale: ILocaleHash
}

class ConstantsView extends React.Component<IConstants, IConstants> {
    render(): React.ReactNode {
        const {locale} = this.props,
            localeList = Object.keys(locale).filter((key)=>key.charAt(0)!=='_').map((key)=>locale[key]).sort(AZ('id'));

        return <Container>
            <NewLocale/>

            {localeList.map((item)=><Constant key={item.id} item={item}/>)}
        </Container>;
    }
}

const ConstantsMap = function (store: IMainStorage): IConstants {
    return {locale: store.locale};
};

export const Constants = connect(ConstantsMap)(ConstantsView);