import {Constants} from "../view/Constants";
import React from "react";
import {Profile} from "../view/Profile";
import {Info} from "../view/Info";
import {setActiveMenu} from "../action-reducers/setActiveMenu";


export interface IComponentLambda {
    (): React.ComponentClass
}
export interface menuItem {
    id: string,
    text: string,
    active ?: boolean,
    view: IComponentLambda
}

export const mainMenu: menuItem[] = [
    {
        id: 'info',
        text: 'Info',
        active: true,
        view: ()=>Info
    },
    {
        id: 'constants',
        text: 'Constants',
        view: ()=>Constants
    },
    {
        id: 'profile',
        text: 'Profile',
        active: true,
        view: ()=>Profile
    }];

setActiveMenu(mainMenu.filter((el)=>el.active)[0].id)
