import React from "react";
import {connect} from "react-redux";
import {IMainStorage} from "../action-reducers";
import {Button, Grid, TextField} from "@material-ui/core";
import {addLocaleTemplate, IAddLocaleTemplate} from "../action-reducers/addLocaleTemplate";
import {getUUID} from "../helpers";

export interface INewLocaleTemplate {
    id: string
}

class NewLocaleTemplateView extends React.Component<INewLocaleTemplate, {}> {
    state = {
        expanded: false,
        text: ''
    };

    addAction() {
        addLocaleTemplate({id: this.props.id, template: {uuid: getUUID(), text: this.state.text}});
        this.setState({expanded: false, text: ''})

    }

    render(): React.ReactNode {
        return <div>
            {this.state.expanded ?
                <div>
                    <Grid spacing={1} container>
                        <Grid item>
                            <TextField
                                value={this.state.text}
                                onKeyDown={(e) => e.key === 'Enter' && e.ctrlKey && this.addAction()}
                                onChange={(e) => this.setState({text: e.target.value})}
                                margin="normal"
                                inputProps={{'aria-label': 'bare'}}
                            />
                        </Grid>
                        <Grid item>
                            <Button variant="contained" color="secondary" onClick={() => this.addAction()}>
                                + Сохранить (Ctrl+enter)
                            </Button>
                        </Grid>
                        <Grid item>
                            <Button variant="contained" color="primary"
                                    onClick={() => this.setState({expanded: false})}>– Передумал</Button>
                        </Grid>
                    </Grid>
                </div>
                :
                <Button variant="contained" color="secondary" onClick={() => this.setState({expanded: true})}>
                    + Новый шаблон
                </Button>
            }
        </div>;
    }
}


export const NewLocaleTemplate = NewLocaleTemplateView;