import React, {ChangeEvent} from "react";
import {Button, Container, List, ListItem, TextField} from "@material-ui/core";
import {addLocale} from "../action-reducers/addLocale";

export interface INewLocale {
    id: string
}

class NewLocaleView extends React.Component<{}, INewLocale> {
    state = {
        id: ''
    };
    changed(e: ChangeEvent) {
        this.setState({id: (e.target as HTMLInputElement).value});
    }
    addLocale(){
        const {id} = this.state;
        addLocale({id})
        this.setState({id: ''});
    }
    render(): React.ReactNode {
        const {id} = this.state;

        console.log(id);
        return <List>
            <ListItem>
                <TextField
                    margin="normal"
                    inputProps={{ 'aria-label': 'bare' }}
                    onChange={(e)=>this.changed(e)}
                    value={id}
                />
                <Button variant="contained" color="primary" onClick={()=>this.addLocale()}>+ Новая локализационная стринга</Button>
            </ListItem>
        </List>;
    }
}


export const NewLocale = NewLocaleView;