import React from "react";
import {setActiveMenu} from "../action-reducers/setActiveMenu";
import {List, ListItem, ListItemText} from "@material-ui/core";
import {mainMenu} from "../model/mainMenu";
import {connect} from "react-redux";
import {IMainStorage} from "../action-reducers";

export interface IMainAsideMenu {
    activeMenu: string
}
class MainAsideMenuView extends React.Component<IMainAsideMenu, IMainAsideMenu> {
    render(): React.ReactNode {
        const {activeMenu} = this.props;

        return <List>
            {mainMenu.map((item) => (
                <ListItem button selected={(activeMenu === item.id)} key={item.id} onClick={() => {
                    setActiveMenu(item.id)}}>
                <ListItemText color={(activeMenu === item.id) ? "primary" : "secondary"} primary={item.text}/>
                </ListItem>
            ))}
        </List>;
    }
}

const mapStoreToMenu = function(store:IMainStorage): IMainAsideMenu{
    return {activeMenu: store.activeMenu};
};

export const MainAsideMenu = connect(mapStoreToMenu)(MainAsideMenuView);