import React from "react";
import {connect} from "react-redux";
import {IMainStorage} from "../action-reducers";
import {IMainAsideMenu} from "./MainAsideMenu";
import {mainMenu} from "../model/mainMenu";
export interface IContent extends IMainAsideMenu {

}

class ContentView extends React.Component<IContent, IContent> {
    render(): React.ReactNode {
        const {activeMenu} = this.props;
        const item = mainMenu.filter((item)=>item.id===activeMenu)[0];
        if(item){
            const View = item.view();
            return <View/>
        }
        console.warn('no view', activeMenu);
        return null;
    }
}

const ContentMap = function (store: IMainStorage): IContent {
    return {activeMenu: store.activeMenu};
};

export const Content = connect(ContentMap)(ContentView);