import React from "react";
import {connect} from "react-redux";
import {ILocale, IMainStorage} from "../action-reducers";
import {Button, List, ListItem, ListSubheader, TextField} from "@material-ui/core";
import {NewLocaleTemplate} from "./NewLocaleTemplate";


export interface IConstant {
    item: ILocale
}

class ConstantView extends React.Component<IConstant, IConstant> {
    render(): React.ReactNode {
        const {id, values} = this.props.item;

        return <List subheader={<ListSubheader>{id}</ListSubheader>}>

                    {values.map((val)=>
                        <ListItem key={val.uuid}>
                            {val.text}
                            {/*<TextField
                                value={val.text}
                                margin="normal"
                                inputProps={{ 'aria-label': 'bare' }}
                            />*/}
                        </ListItem>
                    )}
                    <NewLocaleTemplate id={id}/>


        </List>;
    }
}


export const Constant = ConstantView;
