import {Action, IMainStorage} from './index';

export interface IAddLocale {
    payload: {id: string}
}


export const addLocale = Action('ADD_LOCALE', function (state: IMainStorage, {payload}: IAddLocale) {
    if(payload.id in state.locale)
        return state;
    else
        return {...state, locale: {
                ...state.locale,
                [payload.id]: {
                    id: payload.id,
                    values: []
                }
            }};
});