import React from 'react';
import Container from '@material-ui/core/Container';
import Typography from '@material-ui/core/Typography';
import Box from '@material-ui/core/Box';
import Link from '@material-ui/core/Link';

import {Grid} from "@material-ui/core";
import store from "./store";
import {MainAsideMenu} from "./component/MainAsideMenu";
import { Provider } from "react-redux";
import {Content} from "./component/Content";

function MadeWithLove() {
  return (
    <Typography variant="body2" color="textSecondary" align="right">
      {'Built with love by the '}
      <Link color="inherit" href="https://material-ui.com/">
        Material-UI
      </Link>
      {' team.'}
    </Typography>
  );
}


export class App extends React.Component<{}, {}> {
  render() {
    return (
        <Provider store={store}>
      <Container maxWidth="xl">
        <Grid container direction="row" justify="flex-start" alignItems="stretch">
          <Box my={4}>
            <MainAsideMenu/>

          </Box>
          <Box my={4}>
            <Content/>
            {/*<Typography variant="h4" component="h1" gutterBottom>
              Create React App v4-beta example with TypeScript
            </Typography>
            */}
            {/*<ProTip/>

            <MadeWithLove/>
            <Button variant="contained">12345</Button>
            <Button variant="contained" color="primary">12345</Button>
            <Button variant="contained" color="secondary">12345</Button>*/}
          </Box>
        </Grid>
      </Container>
        </Provider>
    );
  }
};
