import {Info, Content, Note, Header, SubHeader, Field} from '/cmp/Blocks.jsx';

import { PlainSelect } from "cmp/PlainSelect/PlainSelect.jsx";
import { Checkbox } from "cmp/Checkbox/Checkbox.jsx";
import { Radio } from "cmp/Radio/Radio.jsx";
import { Input } from "cmp/Input/Input.jsx";
import { TimeInput } from "cmp/TimeInput/TimeInput.jsx";
import { NumberInput } from "cmp/NumberInput/NumberInput.jsx";

import Add from "/svg/ic_add.svg";
import "./Stack.scss";
import { Collapse } from "cmp/Collapse/Collapse.jsx";


var Stack = function(){
  s.set( {
    'constructor.Microservice': false,
    'constructor.Portal': 'simple',
    'constructor.Video': 'micro',
    'constructor.smartTV': ['WebOS'],
    'constructor.Mobile': 'web',
    'constructor.Locale': 'rus',
    'constructor.design': 'asIs',
    'constructor.2fa': 'no2fa'

  } );

  var toggle = function(key, val) {
    var arr = s.get(key);
    if(arr.indexOf(val) > -1){
      var spliced = arr.slice(0);
      spliced.splice(arr.indexOf(val), 1);
      s.set(key, spliced);
    }else{
      s.set(key, arr.slice(0).concat(val));
    }
  };
  var dom = <div class={'stack'}>
    <Header>Технологический стэк</Header>

    <SubHeader>Шина данных</SubHeader>
    <Content>

      <Collapse label={'Технические детали'} value={true}>
        <p>Очередь задач — Message Queue.
          Единая очередь сообщений связывающая все компоненты системы.
          Понадобится при реализации микросервисного подхода.</p>
        <p>При поступлении в систему любой новой задачи, например:</p>
        <ul>
          <li>загрузка нового видео для перекодировки</li>
          <li>авторизация пользователя</li>
          <li>регистрация пользователя</li>
          <li>добавление комментария</li>
          <li>проверка прав доступа для удаления видео</li>
        </ul>


        <p>То есть любое действие заносится в шину данных.
          Микросервис который имеет возможность выполнить задачу забирает её из очереди и обрабатывает. После завершения кладёт результат (или ссылку на результат) обратно в очередь.</p>
        <p><b>Плюсы использования:</b></p>
        <ul>
          <li>Масштабируемость системы. Если загруженность очереди растёт быстрее чем задачи успевают обрабатываться —
            мы можем моментально масштабировать инфраструктуру.</li>
          <li>На рынке есть множество готовых бесплатных или не сильно дорогих решений.</li>
          <li>Возможность писать части системы на разных прикладных языках.</li>
        </ul>

        <p><b>Минусы:</b></p>
        <ul>
          <li>Увеличение времени разработки. При разработке MVP системы можно сэкономить 25% времени если сделать монолитное не масштабируемое решение.</li>
        </ul>
        <img src={'mq.png'}/>
      </Collapse>


      <button onClick={()=>s.set('constructor.Microservice', false)}
              cls={D.cls('option', {active: s.valEqual('constructor.Microservice', false)})}>
        Монолитная платформа
      </button>
      <button onClick={()=>s.set('constructor.Microservice', true)}
              cls={D.cls('option', {active: s.valEqual('constructor.Microservice', true)})}>
        Микросервисы
      </button>
    </Content>



    <SubHeader>Портал, социальная сеть</SubHeader>
    <Content>
      <p>Портал и соцальная сеть имеют единый технологический стек. Страница пользовательской музыкальной группы может полностью повторить один из интегрированных нами проектов.</p>
      <p>Часть системы реализует разделы и авторизацию пользователей является обязательной.</p>
      <p>Проверку прав доступа и социальную сеть (добавление, удаление, редактирование контента и разделов) можно отложить на последующие этапы.</p>

      <Info>Опции перечислены в порядке возрастания сложности реализации:</Info>
      <button onClick={()=>s.set('constructor.Portal', 'noContent')}
              cls={D.cls('option', {active: s.valEqual('constructor.Portal', 'noContent')})}>
        В системе имеются только заведённые нами проекты и контент.
      </button>
      <button onClick={()=>s.set('constructor.Portal', 'simple')}
              cls={D.cls('option', {active: s.valEqual('constructor.Portal', 'simple')})}>
        Появляются формы и логика для добавления комментариев и оценок.
      </button>
      <button onClick={()=>s.set('constructor.Portal', 'content')}
              cls={D.cls('option', {active: s.valEqual('constructor.Portal', 'content')})}>
        Пользователи получают возможность добавлять контент (видео, текст) в проекты.
      </button>
      <button onClick={()=>s.set('constructor.Portal', 'moderator')}
              cls={D.cls('option', {active: s.valEqual('constructor.Portal', 'moderator')})}>
        Модераторы. Появляются права доступа. Некоторые пользователи наделяются модераторскими правами. Они позволяют редактировать контент. В системе появляется пользовательская админка.
      </button>
      <button onClick={()=>s.set('constructor.Portal', 'social')}
              cls={D.cls('option', {active: s.valEqual('constructor.Portal', 'social')})}>
        Социальная сеть. Пользователи получают личное пространство в котором они могут публиковать видео, тексты, фотографии и аудио.
      </button>
      <button onClick={()=>s.set('constructor.Portal', 'socialGroup')}
              cls={D.cls('option', {active: s.valEqual('constructor.Portal', 'socialGroup')})}>
        В социальной сети появляются группы. В группы можно добавлять других пользователей и назначать им роли.
      </button>


    </Content>

    <SubHeader>Видеоплатформа</SubHeader>
    <Content>
      <Info>Список доступных реализаций видеоплатформы упорядоченный по масштабу:</Info>
      <button onClick={()=>s.set('constructor.Video', 'nano')}
              cls={D.cls('option', {active: s.valEqual('constructor.Video', 'nano')})}>
        В систему загружен набор подготовленных видеофайлов. Подходит для начальных демонстраций интерактивных частей платформы, а именно: наложенных опросов.
      </button>
      <button onClick={()=>s.set('constructor.Video', 'micro')}
              cls={D.cls('option', {active: s.valEqual('constructor.Video', 'micro')})}>
        Система позволяет загружать видео и воспроизводит его как есть (без перекодирования). Подходит для MVP. Можно демонстрировать «загрузку нового контента».
      </button>

      <button onClick={()=>s.set('constructor.Video', 'tiny')}
              cls={D.cls('option', {active: s.valEqual('constructor.Video', 'tiny')})}>
        Полноценная реализация, малый масштаб. Перекодирование видео на нашем сервере, очередь перекодировки, отложенное добавление контента. Раздача с одного сервера.
      </button>

      <button onClick={()=>s.set('constructor.Video', 'small')}
              cls={D.cls('option', {active: s.valEqual('constructor.Video', 'small')})}>
        Всё из предыдущего шага +OTT open source решение для потоковой трансляции.
      </button>

      <button onClick={()=>s.set('constructor.Video', 'small2')}
              cls={D.cls('option', {active: s.valEqual('constructor.Video', 'small2')})}>
        Масштабирование предыдущего этапа. Добавляется балансировка траффика и возможность добавления серверов.
      </button>

      <Info>Industrial grade:</Info>


      <button onClick={()=>s.set('constructor.Video', 'normal')}
              cls={D.cls('option', {active: s.valEqual('constructor.Video', 'normal')})}>
        Берём готовое решение для Перекодирования, хранения и CDN в Amazon AWS. Прогнозируемо масштабируем весь продукт с помощью кредитной карты.
      </button>



      <button onClick={()=>s.set('constructor.Video', 'big')}
              cls={D.cls('option', {active: s.valEqual('constructor.Video', 'big')})}>
        Строим решение аналогичное Amazon на своих мощностях
      </button>
    </Content>

    <SubHeader>SmartTV платформа</SubHeader>
    <Content>
      <Info>На рынке представлены несколько различных платформ smartTV. При мастабировании платформа должна занимать всё большее количество доступных устройств.</Info>

      <button onClick={()=>toggle('constructor.smartTV', 'WebOS') }
              cls={D.cls('option', {
                active: _=>s.sub('constructor.smartTV', val=> _(val.indexOf('WebOS')>-1))
              })}>
        WebOS LG
      </button>

      <button onClick={()=>toggle('constructor.smartTV', 'Tizen') }
              cls={D.cls('option', {
                active: _=>s.sub('constructor.smartTV', val=> _(val.indexOf('Tizen')>-1))
              })}>
        Tizen Samsung
      </button>

      <button onClick={()=>toggle('constructor.smartTV', 'Chromecast') }
              cls={D.cls('option', {
                active: _=>s.sub('constructor.smartTV', val=> _(val.indexOf('Chromecast')>-1))
              })}>
        Chromecast Google
      </button>

      <button onClick={()=>toggle('constructor.smartTV', 'Amazon') }
              cls={D.cls('option', {
                active: _=>s.sub('constructor.smartTV', val=> _(val.indexOf('Amazon')>-1))
              })}>
        Fire TV Amazon
      </button>

      <button onClick={()=>toggle('constructor.smartTV', 'Browser') }
              cls={D.cls('option', {
                active: _=>s.sub('constructor.smartTV', val=> _(val.indexOf('Browser')>-1))
              })}>
        Use Web Browser to view videos
      </button>

    </Content>

    <SubHeader>Мобильная платформа</SubHeader>
    <Content>
      <button onClick={()=>s.set('constructor.Mobile', 'web')}
              cls={D.cls('option', {active: s.valEqual('constructor.Mobile', 'web')})}>
        Мобильное веб-приложение доступное для запуска на Android >= 8.0 и iOS >= 13
      </button>

      <button onClick={()=>s.set('constructor.Mobile', 'app')}
              cls={D.cls('option', {active: s.valEqual('constructor.Mobile', 'app')})}>
        Нативные мобильные приложения для Android и iOS.
      </button>
    </Content>

    <SubHeader>Локализация</SubHeader>
    <Content>
      <button onClick={()=>s.set('constructor.Locale', 'rus')}
              cls={D.cls('option', {active: s.valEqual('constructor.Locale', 'rus')})}>
        Русский язык
      </button>
      <button onClick={()=>s.set('constructor.Locale', 'en')}
              cls={D.cls('option', {active: s.valEqual('constructor.Locale', 'en')})}>
        Английский язык
      </button>
      <button onClick={()=>s.set('constructor.Locale', 'rusSystem')}
              cls={D.cls('option', {active: s.valEqual('constructor.Locale', 'rusSystem')})}>
        Русский язык с системой локализации
      </button>

      <button onClick={()=>s.set('constructor.Locale', 'rusEnSystem')}
              cls={D.cls('option', {active: s.valEqual('constructor.Locale', 'rusEnSystem')})}>
        Русский и английский язык с системой локализации
      </button>

      <button onClick={()=>s.set('constructor.Locale', 'system')}
              cls={D.cls('option', {active: s.valEqual('constructor.Locale', 'system')})}>
        Расширенная система локализации с административными утилитами для локализаторов
      </button>
    </Content>

    <SubHeader>Дизайн-система</SubHeader>
    <Content>
      <button onClick={()=>s.set('constructor.design', 'asIs')}
              cls={D.cls('option', {active: s.valEqual('constructor.design', 'asIs')})}>
        Вёрстка макетов
      </button>

      <button onClick={()=>s.set('constructor.design', 'components')}
              cls={D.cls('option', {active: s.valEqual('constructor.design', 'components')})}>
        Дизайн-система из готовых компонентов для построения всех страниц
      </button>
    </Content>

    <SubHeader>Двуфакторная авторизация</SubHeader>
    <Content>
      <button onClick={()=>s.set('constructor.2fa', 'no2fa')}
              cls={D.cls('option', {active: s.valEqual('constructor.2fa', 'no2fa')})}>
        Не интегрируем двуфакторную авторизаци
      </button>

      <button onClick={()=>s.set('constructor.2fa', 'tuFaSMS')}
              cls={D.cls('option', {active: s.valEqual('constructor.2fa', 'tuFaSMS')})}>
        Двуфакторная авторизация по смс
      </button>

      <button onClick={()=>s.set('constructor.2fa', 'tuFaEmail')}
              cls={D.cls('option', {active: s.valEqual('constructor.2fa', 'tuFaEmail')})}>
        Двуфакторная авторизация по e-mail
      </button>

      <button onClick={()=>s.set('constructor.2fa', 'tuFaBoth')}
              cls={D.cls('option', {active: s.valEqual('constructor.2fa', 'tuFaBoth')})}>
        Двуфакторная авторизация по e-mail и смс
      </button>
    </Content>
  </div>;
  return dom;
};

export {Stack};