import {Info, Content, Note, Header, SubHeader, Field} from '/cmp/Blocks.jsx';

import { PlainSelect } from "cmp/PlainSelect/PlainSelect.jsx";
import { Checkbox } from "cmp/Checkbox/Checkbox.jsx";
import { Radio } from "cmp/Radio/Radio.jsx";
import { Input } from "cmp/Input/Input.jsx";
import { TimeInput } from "cmp/TimeInput/TimeInput.jsx";
import { NumberInput } from "cmp/NumberInput/NumberInput.jsx";

import Add from "/svg/ic_add.svg";
import "./Plan.scss";
import { Collapse } from "cmp/Collapse/Collapse.jsx";


var Plan = (function(h) {
  var D = h.h;
  D.div = h.div;
  D.span = h.span;
  D.join = h.join;
  D.appendChild  = h.appendChild ;
  var Plan = function () {
    s.set({});

    var Title = function (c, ch) {
      if (typeof c === 'string') {
        return D('div', {cls: 'title-wrap'}, D('div', {cls: 'title ' + c}, ch));
      } else {
        c.cls += ' title'
        return D('div', {cls: 'title-wrap'}, D('div', c, ch));
      }
    };
    var numberFormat = function (num) {
      var strNum = num + '';
      var i,
          out = [],
          _i = strNum.length,
          count = (_i % 3) || 3,
          last = count;

      out.push(strNum.substr(0, count));
      count = 3;
      for (i = last; i < _i; i += 3) {
        out.push(strNum.substr(i, count))
      }
      return out.join(',');
    };
    (function (w) {
      var L = function () {

          },

          l = L.prototype = {
            _plural: function (n) {
              return (n % 10 == 1 && n % 100 != 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)
            },
            plural: function (num) {
              return arguments[l._plural(num) + 1];
            }
          };

      w.Localizer = w.L = new L;
    })(window);

    var div = function (cls, data) {
      return D('div', {cls: cls || ''}, data);
    };
    var comment = function (data) {
      return D('div', {cls: 'comment'}, data);
    };
    var list = function (title, items) {
      var mapped = [];
      for (var i = 0, _i = items.length; i < _i; i++) {
        var item = items[i];
        mapped.push(D('li', {cls: 'list-item'}, item));
      }
      return [D('div', {cls: 'list-title'}, title), D('ul', {cls: 'list'}, mapped)];
    };

    var jobs = {
      front: {name: 'Фронтэнд', price: 25},
      layout: {name: 'Вёрстка', price: 20},
      integration: {name: 'Интеграция', price: 12},
      model: {name: 'Архитектура', price: 32},
      admin: {name: 'Администрирование', price: 25},
      back: {name: 'Бэкэнд', price: 27},
      locale: {name: 'Локализация', price: 9},
    };
var pages = [
  {
    title: 'Главная страница',
    description: 'Страница со списком проектов доступных пользователю платформы',
    front: 24, layout: 16,
    integration: 16,
    back: 16,
    model: 8
  },
  {
    title: 'Страница авторизации и регистрации',
    description: 'Адаптивная страница регистрации и авторизации пользователя',
    front: 8, layout: 2,
    integration: 4,
    back: 4,
    model: 4
  },
  {
    title: 'Страница раздела',
    description: 'Страница внутренней части раздела.',
    front: 16, layout: 12,
    integration: 16,
    back: 16,
    model: 4
  },
  {
    title: 'Редактор интерактива',
    description: 'Редактор видео позволяющий добавлять интерактивные слои, назначать эффект появления и исчезновения слоёв, определять время и настройки слоёв. Осуществлять предпросмотр результата наложения интерактива.',
    front: 8*5*2, layout: 24,
    integration: 24,
    back: 8,
    model: 16
  },
  {
    title: 'Страница видеоролика',
    description: 'Страница отображающая видеоролик, список серий, информацию о видео-ролике',
    front: 16, layout: 6,
    integration: 8,
    back: 4,
    model: 6
  },

  {
    title: 'Страница добавления видео',
    description: 'Страница содержит компонент загрузки файла и предоставляет интерфейс для задания свойств видеофайла',
    tag: '(micro||tiny||small||small2||normal||big)&&(content||moderator||social||socialGroup)',
    front: 24, layout: 8,
    integration: 16,
    back: 32,
    model: 4
  },
  {title: 'Страница отображающая последовательность челленджа',  tag: '(micro||tiny||small||small2||normal||big)&&(content||moderator||social||socialGroup)',
    front: 16, layout: 16,
    integration: 4,
    back: 4,
    model: 4},
  {title: 'Персональная страница в социальной сети', description: 'Личная страница пользователя на которой он может размещать свой контент',  tag: '(micro||tiny||small||small2||normal||big)&&(content||moderator||social||socialGroup)',
    front: 16, layout: 16,
    integration: 8,
    back: 4,
    model: 16},
  {title: 'Страница группы в социальной сети', description: 'Страница группы содержит описание группы, список пользователей добавленных в группу, комментарии группы, список модераторов с правами удалять комментарии и редактировать описание',  tag: '(micro||tiny||small||small2||normal||big)&&(content||moderator||social||socialGroup)',
    front: 16, layout: 8,
    integration: 8,
    back: 8,
    model: 3},
  {title: 'Профиль пользователя', description: 'Информация о пользователе. Если пользователь просматривает свою страницу, то у него есть возможность отредактировать имеющуюся на странице информацию, в том числе загрузить новый аватар',  tag: '(micro||tiny||small||small2||normal||big)&&(content||moderator||social||socialGroup)',
    front: 8, layout: 4,
    integration: 8,
    back: 2,
    model: 2},
  {title: 'Личный кошелёк', description: 'Страница отображает текущий баланс и список из 30 последних транзакций',
    front: 4, layout: 2,
    integration: 2,
    back: 24,
    model: 24}
];
    var work = [
      {
        title: 'Разработка ОТТ платформы МИР',
        description: [
          list('Для разработки OTT платформы требуется реализовать базовые части', [
            'Модели данных в которых будет храниться вся информация платформы',
            'Backend предоставляющий данные в пользовательские приложения и предоставляющий машинный интерфейс для наполнения и редактирования информации',
            'smartTV и мобильные приложения',
            'Локализация системы',
            "Дизайн макетов",
            'Вёрстка дизайна',
            'Проработка логики компонентов, групп компонентов и типовых блоков',
            'Воспроизведение видео',
            'Редактирование интерактивного содержания видео',
            'Социальные сервисы'
          ]),
          comment('Дальнейший список задач и предварительное оценочное время их реализации необходимо для долгосрочного планирования проекта.')
        ],
        items: [
          {
            title: 'Подготовка инфраструктуры для разработки',
            description: [
              'Работы по настройке серверов должны быть выполнены специалистами знакомыми с практиками CI\CD (непрерывной интеграции и развёртывания).',
              list('Работы включают в себя следующие обязательные шаги', [
                'развёртывание инфраструктуры для непрерывной интеграции. Jenkins',
                'настройка инфраструктуры для запуска автоматических интеграционных тестов',
                'создание упрощённой версии инфраструктуры для работы ручных тестировщиков',
                'развёртывание и настройка трекера задач. Jira или YouTrack',
                'подготовка репозитория с кодом',
                'установа вики для хранения всей информации о разработанных частях системы (ввод новых разработчиков и ускорение интеграции частей системы между собой)'
              ])
            ],
            admin: 24
          },


          {
            title: 'Единая точка обработки входящих запросов',
            description: 'Все запросы пользователей поступают в единую точку - API для последующей обработки конкретными модулями. Реализация базового backend модуля',
            admin: 8,
            model: 4,
            back: 8,
            items: [
              {
                title: 'Модульная система',
                description: 'Модуль должен автоматически регистрироваться в API системе и сообщать ей своё название, список реализуемых, методов и их параменты',
                model: 2,
                back: 8,
                integration: 8,
              },
              {
                title: 'Демонстрационный модуль',
                description: 'Модуль являющийся образцом для разработки других модулей. Является живой документацией. Должен реализовывать два метода доступных для вызова: ассинхронный отложенный и синхронный.',
                model: 4,
                back: 4
              }
            ],
            tag: 'api'
          },
          {
            title: 'Микросервисная архитектура',
            admin: 32,
            back: 24,
            integration: 8,
            description: 'Каждая система представлена отдельным независимым сервисом использующим шину данных для общения с другими сервисами.',
            items: [
              {
                title: 'Базовый микросервис',
                description: 'Разработка демонстрационного модуля реализующего сообщения информации о себе системе через шину данных. Модуль должен реализовывать два метода: один выполняющий действие - запрос на заданный URL, второй - выполняющий запрос и возвращающий результат. Данный модуль нужен в качестве образца для написания других модулей. Любой метод можно рассматривать в качестве узла Remote Procedure Call',
                back: 8,
                integration: 8,
              },
              {
                title: 'Микросервис для регистрации микросервисов',
                description: 'Разработка микросервиса отвечающего за регистрацию других микросервисов и их методов в системе. Произвести реализацию на основе базового микросервиса',
                back: 16,
                integration: 4,
                model: 8
              }
            ],
            tag: 'microservice'
          },
          {
            title: 'Контентная часть',
            description: 'Социальная сеть и хранение, отображение, изменение всех загружаемых данных',
            items: [
              {
                tag: 'noContent||simple',
                title: 'Отображение только предвариательно заведённых нами проектов и контента',
                items: [
                  {
                    title: 'Модель проекта',
                    description: 'Проработка структуры для хранения настроек проекта',
                    model: 40,
                    back: 8

                  },
                  {
                    title: 'Заведение проектов и их вложенной структуры',
                    description: 'Ручное наполнение модели проектов структурой согласно мокапам',
                    integration: 40
                  },
                  {
                    title: 'Перекодирование видео, наполнение разделов',
                    description: 'Ручное перекодирование видео и его добавление в разделы проектов с форматированным описанием',
                    integration: 40,
                    admin: 16,
                    back: 16,
                    front: 26
                  }
                ]
              },

              {
                tag: 'simple||content||moderator||social||socialGroup',
                title: 'Пользователи комментируют и оценивают контент',
                items: [
                  {
                    title: 'Комментарии',
                    description: [
                      list('Модуль отвечает за все операции связанные с комментариями. Абстракция комментариев необходима для',
                          ['отображения комментариев к контенту',
                            'общения пользователей через внутреннюю почту (личные сообщения)',
                            'отображения комментариев на личной странице пользователя',
                            'отображения уведомлений в произвольных разделах',
                            'связи с техподдержкой'])

                    ],
                    items: [
                      {
                        title: 'Разработка модели комментария',
                        description: 'Разработка и реализация модели комментариев позволяющей добавлять комментарий к любой SystemID сущности. Комментарий должен иметь возможность добавляться в виде ответа на другой комментарий и тем самым представлять собой древовидную структуру. Комментарий должен содержать в себе как минимум: текст, автора, дату, ссылку на родительский объект.',

                        back: 8, integration: 8, front: 24, layout: 4
                      },
                      {
                        title: 'Количество непрочитанных комментариев',
                        description: 'Пользователь должен иметь возможность узнать количество новых комментариев в некоторой сущности, а при заходе в просмотр комментариев - иметь возможность визуально отличить уже просмотренные комментарии от новых',

                        back: 16, layout: 4, front: 8, model: 16, integration: 8
                      }
                    ]

                  },
                  {
                    title: 'Оценки',
                    description: 'Пользователи могут оценивать контент по различным критериям',
                    items: [
                      {
                        title: 'Модель оценки',
                        description: 'Определить требуемую модель для хранения оценок и реализовать методы добавления и изменения оценки.',
                        back: 16,
                        model: 8,
                        integration: 3
                      },
                      {
                        title: 'Типы оценок',
                        description: 'Задать возможные типы оценок и реализовать соответствующие формы с пользовательским интерфейсом',
                        back: 4,
                        front: 8,
                        layout: 8,
                        integration: 3
                      }
                    ]
                  }
                ]
              },
              {
                tag: 'content||moderator||social||socialGroup',
                title: 'Пользователи создают контент и доабвляют его',
                description: 'Любой пользователь может загрузить в проект свой видеоролик или текстовую статью',
                items: [
                  {
                    title: 'Видео',
                    items: [
                      {
                        title: 'Загрузка видеофайла из браузера пользователя',
                        front: 16,
                        back: 24,
                        model: 4,
                        integration: 16,
                        layout: 2
                      },
                      {title: 'Перекодирование видоефайлов', description: 'После загрузки происходит перекодирование видеофайлов в форматы подходящие для просмотра в стандартном стеке веб технологий',
                        integration: 16,
                        admin: 8*5},
                      {title: 'Хранение видео', description: 'Модель для хранение перекодированных видеофайлов связаная с видеоплеером',
                        back: 8,
                        model: 8,
                        integration: 16,
                        admin: 8*4}
                    ]

                  },//TODO!!!!
                  {
                    tag: 'content||moderator||social||socialGroup',
                    title: 'Текстовый контент', description: 'What you see is what you get редактор текста для написания статей и заметок',
                    front: 24,
                    back: 8,
                    model: 8,
                    integration: 8,
                    layout: 4
                  }
                ]
              },

              {
                tag: 'moderator||social||socialGroup',
                title: 'Модераторы',
                items: [
                  {title: 'Назначение пользователя модератором',
                    front: 4, layout: 2,
                    integration: 4,
                    back: 4,
                    model: 2},
                  {title: 'Интерфейс модерирования',
                    front: 16, layout: 4,
                    integration: 4}
                ]
              },

             /* {tag: 'social||socialGroup'}, //TODO!!
              {tag: 'socialGroup'}// TODO!!*/


            ]
          },
          {
            title: 'Пользователи',
            description: 'Пользователь должен иметь возможность выполнять весь спектр возможных в системе действий',
            items: [

              {title: 'Модель пользователя',
                back: 4,
                model: 16},
              {title: 'Регистрация пользователя',
                back: 4},
              {title: 'Авторизация пользователя', back: 6},
              {title: 'Сканер QR кодов', front: 8*5, integration: 8*3},
              {
                title: 'Двуфакторное подтверждение действия пользователя',
                tag: 'tuFaSMS||tuFaBoth||tuFaEmail',
                items: [
                  {title: 'SMS', tag: 'tuFaSMS||tuFaBoth',
                    description: 'Задача включает интеграцию с СМС шлюзом и логику отправки сообщений с авторизационным кодом',
                    front: 8, layout: 4,
                    integration: 8,
                    back: 16,
                    model: 2},
                  {title: 'E-mail', tag: 'tuFaEmail||tuFaBoth',
                    description: 'Для отправки e-mail будет проведена интеграция с сервисом для отправки email. В дальнейшем эту интеграцию можно будет убрать, но в первое время она позволит обойти спам фильтры.',
                    front: 8, layout: 4,
                    integration: 8,
                    back: 4,
                    model: 2},
                ]
              },
              {
                title: 'Слияние пользовательских аккаунтов',
                items: [
                  {title: 'Алгоритм поиска различий', description: 'Система будет предлагать пользователю объединение данных двух аккаунтов в момент слияния',
                    back: 6,
                    model: 2},
                  {title: 'Интерфейс слияния', front: 6, layout: 4,
                    integration: 4}

                ]
              },
              {
                title: 'Права доступа', tag: 'moderator||social||socialGroup',
                items: [
                  {title: 'Модель прав дрступа',
                    model: 8*4},
                  {title: 'Группы прав',

                    model: 8*3},
                  {title: 'Модуль проверки прав', front: 8, layout: 4,
                    integration: 8*2,
                    back: 8*4},
                  {title: 'Пользовательский интерфейс настройки прав доступа', front: 8*2, layout: 8,
                    integration: 8*2},
                ]
              },

            ]
          },
          {
            title: 'Кроссплатформенность',
            description: 'На рынке представлен широкий ассортимент smartTV платформ. Каждый производитель считает своим долгом сделать уникальное решение.',
            items: [
              {tag: 'WebOS', title: 'LG', description: 'Поддержка SmartTV телевизоров LG c FullHD разрешением произведённых после 2019 года',
                front: 8*5*2,layout: 8*3
              },
              {tag: 'Tizen', title: 'Samsung', description: 'Поддержка SmartTV телевизоров Samsung c FullHD разрешением произведённых после 2019 года', front: 8*5*2,layout: 8*3},
              {tag: 'Chromecast',title: 'Google', description: 'Поддержка телевизоров с приставкой от Google c FullHD разрешением. Android >= 8.0', front: 8*5*2,layout: 8*3},
              {tag: 'Amazon', title: 'Amazon', description: 'Поддержка телевизоров с приставкой от Amazon c FullHD разрешением. Android >= 8.0', front: 8*5*2,layout: 8*3},
              {tag: 'Browser', title: 'Web', description: `Поддержка отображение контента в браузерах Google Chrome, Firefox и Microsoft Edge с присутствием на рынке >1%. 
              Вёрстка осуществляется адаптивно, т.е. сайт будет хорошо смотреться как на десктопе, так и на планшете`, front: 8*5*4,layout: 8*6}
            ]
          },
          {
            title: 'Локализация',
            description: 'Тексты локализации в платформе',
            items: [
              {title: 'Русский язык', tag: 'rus||rusEnSystem||rusSystem', description: 'Платформа имеет встроенную поддержку русского языка',
              locale: 4*5*4}, // месяц парттайма
              {title: 'Английский язык', tag: 'en||rusEnSystem', description: 'Платформа имеет встроенную поддержку английского языка',
                locale: 4*5*4}, // месяц парттайма
              {title: 'Утилиты локализатора',
                tag: 'rusSystem||system',
                description: `Платформа будет включать в себя инструменты для заведения любого количества языковых локалей. Инструменты будут позволять выстроить древовидную модель локализационных констант. Текстовый шаблонизатор позволяющий как делать вставки других констант, так и вставлять переменные. Инструменты должны предоставлять возможность корректной работы с числительными (для примера, в русском языке: "1 фильм, 2 фильма, 5 фильмов)".`,
                front: 8, layout: 8,
                integration: 8,
                back: 8*2,
                model: 6},
            ]

          },
          {
            title: 'Типовые блоки', description: 'Стандартные блоки из которых будут строиться страницы', items: [
              {
                title: 'Типы обложек разделов',
                description: 'В макетах существует несколько похожих компонентов обложки раздела, подраздела, списка видеофайлов и топа. Все эти блоки будут собраны на основе обложки раздела и будут доступны для переиспользования.',
                front: 8, layout: 4,
                integration: 4,
                back: 2,
                model: 2
              },
              {
                title: 'Интерактивный слой', description: 'Слой доступный для наложения на поток видео. Любой слой предоставляет возможность назначить время появления, продолжительность присутствия, эффект появления и скрытия.',
                front: 16, layout: 4,
                integration: 2,
                back: 2,
                model: 2,

                items: [
                  {
                    title: 'Опрос', description: `Выбор ответа из предложенных вариантов.

Действие доступно как из приложения smartTV с помощью пульта, так и с мобильного телефона.

Настраивается позиция блока, количество и текст вариантов. При включенной опции «Свой вариант» — зритель получает возможность ввести свой текст.`,
                    front: 16, layout: 6,
                    integration: 4,
                    back: 8,
                    model: 4
                  },
                  {
                    title: 'Вопрос', description: `Предлагает зрителю ответить на вопрос. Без вариантов ответов. Как и опрос, можно реализовать набор фразы из кусочков.

Настраивается максимальная и минимальная длина ответа.`,
                    front: 8, layout: 4,
                    integration: 4,
                    back: 4,
                    model: 2
                  },
                  {
                    title: 'Загадка',
                    description: `Ввод букв в заранее спозиционированные клетки. Позволяет организовывать викторины, онлайн-кроссворды, судоку. Ввод доступен как с мобильного, там и со smartTV приложений. Настраивается стиль клеток, их количество, расположение относительно друг друга и доступные для ввода символы, цвета или даже звуки (конкурс с подбором мелодии!)`,
                    front: 24, layout: 12,
                    integration: 8,
                    back: 4,
                    model: 4
                  },
                  {
                    title: 'Переход',
                    description: `Реализовать элемент навигации, работающий как гиперссылка. Элемент должен выполнять переход в назначенное место. В том числе, позволять перейти к другому времени в текущем видео.`,
                    front: 2, layout: 1,
                    integration: 1,
                    back: 1,
                    model: 1
                  },
                  {
                    title: 'Разветвление сюжета',
                    description: 'Элемент навигации аналогичный переходу, но с остановкой подачи основного контента. Должен реализовывать настройку фона во время ожидания реакции пользователя.',
                    front: 2, layout: 1,
                    integration: 1,
                    back: 1,
                    model: 1
                  },
                  {
                    title: 'Результат опроса',
                    description: 'Не интерактивный элемент. Должен отображать данные существующего опроса.',
                    integration: 2,

                    back: 2,
        model: 4,
                    items: [
                      {title: 'Столбчатый график',
                        front: 4, layout: 1,
                        integration: 1},
                      {title: 'Pie chart',
                        front: 4, layout: 1,
                        integration: 1,
                       }
                    ]
                  },
                  {
                    title: 'Виджет',
                    description: 'Не интерактивный элемент позволяющий отобразить информационный компонент',
                    model: 1,
                    back: 1,
                    items: [
                      {
                        title: 'Прогноз погоды',
                        description: 'Задаётся длительность прогноза до 14 дней. Для реализации требуется интеграция с погодным сервисом',
                        front: 8, layout: 4,
                        integration: 16,
                        back: 1,
                        model: 1
                      },
                      {
                        title: 'Текущую погоду',
                        description: 'Должен настраиваться город для отображения погодных данных. По-умолчанию должна быть установлена текущая гео-позиция зрителя',
                        front: 4, layout: 2,
                        integration: 16,
                        back: 1,
                        model: 1
                      },
                      {
                        title: 'Курс валют',
                        description: 'Задаётся пара валют. Для реализации требуется интеграция с одной из бирж',front: 4, layout: 1,
                        integration: 8,
                        back: 2,
                        model: 1
                      },
                      {title: 'Изображение',front: 1, layout: 1,
                        integration: 1,
                        back: 1,
                        model: 1},
                      {
                        title: 'Текстовый блок',
                        description: 'Блок можно использовать как для встраиваемой рекламы, так и для реализации субтитров. Блок должен позволять настроить шрифт, размер и цвет текста',front: 16, layout: 4,
                        integration: 1,
                        back: 1,
                        model: 1
                      },
                    ]
                  },
                ]
              }
            ]
          },
          {
            title: 'UI-система',
            description: 'Все страницы будут строиться из заранее подготовленных качественных компонентов выполненных в полном соответствии с макетов',
            items: [
              {
                title: 'Текстовое поле',
                description: 'Текстовое поле с синхронизацией и возможностью одновременного ввода текста со smartTV и мобильного устройства',
                front: 8,
                back: 8,
                integration: 16,
                model: 8,
                admin: 4
              },
              {
                title: 'Slider',
                description: 'Компонент позволяющий выбрать число из диапазона. Ввод значения должен осуществляться как из smartTV платформы, так и с мобильного устройства',
                front: 8,
                back: 8,
                integration: 16,
                model: 8,
                admin: 4
              },
              {
                title: 'Обложка раздела',
                description: 'Компонент показывающий список других компонентов. Позволяет задавать фон, заголовок, тизерный элемент и список дочерних компонентов',
                front: 16,
                layout: 12,
                back: 4,
                integration: 4,
                model: 4
              },
              {
                title: 'Button',
                description: 'Кнопка с возможностью нажатия со smartTV и мобильного устройства. Должна иметь возможность принимать недоступное для нажатия состояние. Должна содержать свойства: текст, иконка, стиль',
                front: 2,
                layout: 1,
                back: 2,
                integration: 2
              },
              {
                title: 'Древовидная горизонтальная последовательность',
                description: 'Компонент отображает список других компонентов с заданными характеристиками позиций и связей. Используется для отображения череды серий',
                front: 24,
                layout: 16,
                back: 8,
                integration: 8,
                model: 8
              },
              {title: 'Список', description: 'Список элементов с возможностью добавления и удаления элементов',
                front: 8,
                layout: 2},
              {
                title: 'Видеоплеер',
                description: 'Адаптированный под наш дизайн видеоплеер с интегрированной возможностью отображения интерактивного слоя',
                front: 24,
                layout: 2,
                back: 8,
                integration: 16
              },

              {
                title: 'Страницы', description: 'Сборка страниц из компонентов',
                items: pages
              },
            ],
            tag: 'components'
          },
          {
            title: 'Вёрстка макетов',
            description: 'Все страницы будут свёрстаны в соответствии с макетами',
            items: pages.map(a=>{
              return {...a, front: a.front*1.7, layout: a.layout*1.7};
            }),
            tag: 'asIs'
          }


        ]
      }
    ];

    var works = D.div({prop: {id: 'works'}});

    var timeCalculate = function (item, numbers, multiply, cfg) {
      var costs = {};
      for (var n in jobs) {
        costs[n] = 0;
      }
      for (var n in jobs) {
        if (item && n in item)
          costs[n] += item[n] * (item.times || 1);
      }

      if (item.items) {
        for (var i = 0, _i = item.items.length; i < _i; i++) {
          if (!item.items[i])
            continue;
          if (item.items[i].tag){
            if(!checkTag(cfg, item.items[i].tag))
              continue ;
          }
          var subitemCosts = timeCalculate(item.items[i], true, null, cfg);
          for (var n in jobs) {
            costs[n] += subitemCosts[n];
          }

        }
      }
      if (numbers)
        return costs;
      return Object.keys(jobs).map(function (key) {
        return {
          name: jobs[key].name,
          amount: Math.round(costs[key] * (multiply && multiply[key] ? 1 + multiply[key] : 1))
        }
      }).filter(function (cost) {
        return cost.amount;
      }).map(function (cost) {
        return D('div', {cls: 'cost'}, [D('div', {cls: 'cost-name'}, cost.name), D('div', {cls: 'cost-amount'}, cost.amount + ' ' + L.plural(cost.amount, 'час', 'часа', 'часов')), D('div', {cls: 'cost-after'})])
      });
    };
    var toggle = function (e) {
      this.childNodes[0].innerText = this.parentNode.parentNode.classList.toggle('collapsed') ? '+' : '–';
      e.preventDefault();
      e.stopPropagation()
    };
    var builder = function (item) {

      if (typeof item === 'string') {
        /*var tokens = {}, id = 0, uniq = function(data){
          var uuid = id++;
          var str = '%%%@@@a'+uuid+'x@@@%%%';
          tokens[str] = {type, data};
          return str;
        };

        var list = [];
        item.replace(/\*([^\*]+)\*!/g, function(a,b, c){
          return uniq('bold', b)
        })*/
        var rows = item.split('\n');
        if(rows.length>1){
          return D.join(rows,D('br'));
        }else{
          return item;
        }
      }else{
        return item;
      }
    };
//    var tag = '(micro||tiny||small||small2||normal||big)&&(content||moderator||social||socialGroup)';

    var checkTag = function(cfg, tag){

      return (new Function('cfg', 'with(cfg){return '+tag+';}'))(cfg)
    }

    var build = function (arr, el, depth, cfg) {
      for (var i = 0, _i = arr.length; i < _i; i++) {
        var item = arr[i];
        if (!item)
          continue;
        if(item.tag){
          if(!checkTag(cfg, item.tag))
            continue ;
        }
        var sub,
            arrEl = D('div', {cls: 'block'}, [
              Title({
                cls: 'clickable title-' + depth,
                on: {click: toggle}
              }, [item.items ? D('button', {}, '–') : null, item.title + (item.times ? ' x' + item.times : '')]),
              D('div', {cls: 'time'}, timeCalculate(item, null,null,cfg)),
              D('div', {cls: 'description'}, builder(item.description))
            ]);
        if (item.items) {
          sub = D('div', {cls: 'sub'});
          build(item.items, sub, depth + 1, cfg);
          arrEl.appendChild(sub);
        }
        el.appendChild(arrEl)
      }
    };
    var buildHolder = D.div({});
    D.appendChild(works, buildHolder);
    D.appendChild(works, [

      Title('title-2', 'Наши подходы'),

      Title('title-3', 'Оценка времени'),
      Title('title-4', 'Время разработки оценивается с учётом тестирования, отладки, исправления ошибок и менеджмента. Наш опыт позволяет довольно точно прогнозировать сроки.'),

      Title('title-3', 'Используемые технологии'),
      Title('title-4', list('Обычно мы разрабатываем веб-приложения и у нас соответствующий стек технологий', [
        'Node.js — бэкэнд',
        'React-vanilla — пользовательский интерфейс и интерактивность',
        'SCSS — стили вёрстки',
        'NoSQL база данных'
      ])),

      Title('title-3', 'Подходы к разработке'),
      Title('title-4', list('', [
        'Покрываем код тестами — чтобы при изменении одних частей случайно не сломать другие. На крупных проектах такое происходит постоянно и выливается в многочасовой поиск ошибок. Перестраховываемся',
        'Agile — планирование работы недельными спринтами. Позволяет изменить направление реализации проекта в процессе (но план работ и стоимость будут пересчитаны)',
        'DRY (Do not Repeat Yourself) приницип не дублирования кода — где возможно переиспользуем код. Исправление ошибки в одном месте — исправляет сразу в разных',
        ['Пишем техническое задание — стоимость выявления и исправления ошибки растёт на порядки при передвижении по цепочке: ', D('div', {cls: 'nobr'}, ' «бриф → написание тз → проектирование → разработка → доработка»'), '. Фиксируем список работ в момент подписания договора и вносим изменения только через дополнительные Акты.'],
        'Декларативная подход к разработке. Заставляем машину следить за зависимостями данных друг от друга. При традиционном (императивном) подходе программист вынужден держать в голове огромный набор взаимосвязей одних частей приложения от других. Мы стараемся иметь единую точку с данными и автоматическое обновление всего что на неё завязано (как ячейки в экселе)',
      ])),
      comment('Agile и Написание ТЗ противоречат друг-другу. Это два разных варианта работы. В случае Agile мы продаём человеко-часы, в случае ТЗ — результат')
    ]);
    var options = [/*
      {title: 'Написа'}
      {title: 'Поддержка IE 11', layout: 0.5, front: 0.3, admin: 0.2},
      {title: 'Мобильная версия', layout: 0.1, front: 0.1, checked: true, admin: 0.2},
      {title: 'Адаптив', layout: 0.3, checked: true, integration: 0.1, admin: 0.2},
      {title: 'Второй язык', layout: 0.1, front: 0.2, integration: 0.2, model: 0.2, admin: 0.2, checked: true}
    */];

    /*works.appendChild(
        Title('title-1 options', 'Модификаторы времени и стоимости:'));*/

    var calculation, recalculate = function (obj) {
      buildHolder.innerHTML = '';
      build(work, buildHolder, 1, obj);


      calculation.innerHTML = '';
      var addition = {};
      for (var i in jobs) {
        addition[i] = 0.4;
      }
      for (var i = 0, _i = options.length; i < _i; i++) {
        var option = options[i];
        if (option.input.checked) {
          for (var j in jobs) {
            addition[j] += option[j] || 0;
          }
        }
      }
      calculation.appendChild(Title('title-3 sub-options', 'Время работы специалистов:'));

      var divs = timeCalculate(work[0], false, addition, obj);
      for (var i = 0, _i = divs.length; i < _i; i++) {
        var div = divs[i];
        calculation.appendChild(div);
      }
      var costs = timeCalculate(work[0], true, null, obj), sum = 0;
      for (var key in jobs) {
        costs[key] = Math.round(costs[key] * (addition[key] ? 1 + addition[key] : 1));
        sum += costs[key] * jobs[key].price
      }

      var days = (Math.max(costs.front + costs.layout, costs.back + costs.admin + costs.model) + costs.integration +
              (costs.front + costs.layout + costs.integration + costs.model + costs.admin + costs.back) / 8
          ) / 7,
          weeks = days / 5 + 2;
      //console.log(days)


      calculation.appendChild(Title('title-3 sub-options', 'Время разработки: ' +
          Math.ceil(weeks) + ' ' + (L.plural(weeks, 'рабочая неделя', 'рабочие недели', 'рабочих недель'))
      ));

      calculation.appendChild(Title('title-3 sub-options', 'Стоимость работ: $' + numberFormat(sum) + ' или ' + numberFormat(Math.round(sum * 63.57)) + ' руб'));


    };
    for (var i = 0, _i = options.length; i < _i; i++) {
      var option = options[i];
      works.appendChild(
          D('div', {cls: 'option'}, D('label', {cls: 'clickable'}, [option.input = D('input', {
            on: {
              change: recalculate,
              click: recalculate
            }, attr: {type: 'checkbox', checked: option.checked}, prop: {checked: option.checked}
          }), option.title])))
    }

    works.appendChild(Title('title-1 options ', 'Итоговый расчёт'));

    works.appendChild(calculation = D('div', {cls: 'calculation sub'}));
    s.sub([
        'constructor.Microservice', 'constructor.Portal',
      'constructor.Video', 'constructor.smartTV',
      'constructor.Mobile', 'constructor.Locale',
      'constructor.design','constructor.2fa'], function(
        micro, portal, video, smart, mobile, locale, design,tufa
    ){
      var obj = {};
      `noContent,simple,content,moderator,social,socialGroup,
      micro,tiny,nano,small,small2,normal,big,
      WebOS,Tizen,Chromecast,Amazon,Browser,
      web,app,
      rus,en,rusSystem,rusEnSystem,system,
      no2fa,tuFaSMS,tuFaEmail,tuFaBoth
      asIs,components`.split(/[\s\n,]/).map(a=>a.trim()).filter(String).forEach(a=>obj[a]=false);

      obj.api =  !micro;
      obj.microservice = micro;

      obj[portal] = true;
      obj[video] = true;
      smart.forEach(function (s) {
        obj[s] = true;
      });

      obj[mobile] = true;
      obj[locale] = true;
      obj[design] = true;
      obj[design] = true;
      obj[tufa] = true;





      console.log(obj)
      /*console.log(arguments)
*/
      recalculate(obj);
    });


    return works;
  };
  return Plan;
})(D)
export {Plan};