import {Component} from 'cmp/Component.jsx';


var NumberInput = new Component({
  name: 'NumberInput',
  ctor: function(cfg) {
    Object.assign(this, cfg);

    this.createDOM();
    this.initBinding();

    this.afterInit && this.afterInit();
  },
  prop: {
    value: {type: String, default: false}
  },
  createDOM: function() {
    var val = this.value,
      el = this.dom = this.inputEl = D.h('input', {
        attr: {type: 'number'},
        cls: 'cmp-input',
        oninput: function() {
          val.set(el.value|0);
        }
      });

    this.afterDOM && this.afterDOM();
  },
  initBinding: function() {
    var _self = this;

    this.sub([this.value], function (val) {
      _self.inputEl.value = val;
    });

  }
});

export { NumberInput };
