import {Info, Content, Note, Header, SubHeader,SubSubHeader, Field} from '/cmp/Blocks.jsx';

import { PlainSelect } from "cmp/PlainSelect/PlainSelect.jsx";
import { Checkbox } from "cmp/Checkbox/Checkbox.jsx";
import { Radio } from "cmp/Radio/Radio.jsx";
import { Input } from "cmp/Input/Input.jsx";
import { TimeInput } from "cmp/TimeInput/TimeInput.jsx";
import { NumberInput } from "cmp/NumberInput/NumberInput.jsx";

import Add from "/svg/ic_add.svg";
import "./Portal.scss";
import { Collapse } from "cmp/Collapse/Collapse.jsx";


var Portal = function(){
  s.set( {} );
  var dom = <div class={'users'}>
    <Header>Портал-Аттракцион</Header>
    <Info>Этот раздел фиксирует структуру проекта. Структура описана в соответствии с макетами из cacoo.</Info>

    <Content>
      <p>Сложно охарактеризовать разрабатываемый проект более лаконично чем «<i>Портал-Аттракцион</i>»</p>
      <p>Любой наш зритель может как круглосуточно <i>потреблять</i> имеющийся контент, так и <i>создавать</i> нечто своё-новое и выкладывать на всеобщее обозрение.</p>
      <p>Пользователи будут участвовать в опросах и конкурсах. Делать это они смогут не на альтруистических началах, а зарабатывая попутно коины.</p>
    </Content>

    <SubHeader>Структура проекта</SubHeader>
    <SubSubHeader>Раздел</SubSubHeader>
    <Content>

      <p>Базовой структурной единицей проекта является «Раздел».</p><p>Свойства раздела:</p>
      <ul>
        <li>Название — заголовок раздела</li>
        <li>Описание — пояснение описывающее содержание раздела. У одного раздела может быть несколько описаний для разных форматов отображения (короткое, длинное).</li>
        <li>Родительский раздел — если задан, то раздел становится <i>подразделом</i>, если нет — коренным.</li>
        <li>
          <a href="#Права доступа">Права доступа</a>. Определяют кто может наполнять и редактировать раздел.
        </li>
        <li><a href="#Предварительный просмотр раздела">Предварительный просмотр</a> — обложка раздела. Содержит ссылки на подразделы и выборки в соответствии с настройками.</li>
        <li><a href="#Тип контента">Тип контента</a> — указывает какой тип контента можно добавлять в раздел (например: текст, видео, музыка).</li>
      </ul>


    </Content>

    <SubHeader>Права доступа</SubHeader>
    <Content>
      <p>Любой объект в системе имеет права доступа.</p>
      <p>Права доступа похожи на систему прав *nix операционных систем.</p>
      <p>У любого объекта есть <i>создатель</i>.</p>
      <p>Создатель может делать с объектом что угодно, а именно — удалять, редактировать, наполнять, просматривать.</p>
      <p>Создатель может дать права на удаление, редактирование, наполнение и просмотр любому другому пользователю или группе пользователей.</p>
      <p>Группа пользователей — тоже объект. Создатель группы может добавлять в неё других пользователей.</p>
    </Content>

    <SubHeader>Предварительный просмотр раздела</SubHeader>
    <Content>
      <p><i>Обложка</i> раздела — это то, как выглядит раздел до того как в него зашли.</p>
      <p>Пользователь с правами редактирования раздела может добавлять на обложку произвольный набор следующих элементов:</p>
      <ul>
        <li><i>Изображение</i>. Возможно указать несколько различных изображений для различных разрешений экрана.</li>
        <li><i>Текст</i>. Текст может быть описанием раздела или использоваться для любой другой ситуации.</li>
        <li><p><i>Топ</i>. Список элементов контента. Настройка списка включает в себя:</p>
          <p><i>Источник</i> элементов — непосредственно вложенные элементы, все вложенные элементы, элементы одного из вложенных разделов.</p>
          <p><i>Фильтрация</i> — возможность убрать некоторый срез элементов.</p>
          <p><i>Сортировка</i> элементов — свойства по которым элементы будут упорядочены и направление сортировки.</p>
          <p><i>Количество</i> отображаемых элементов.</p>
          <p><i>Шаблон</i> отображения элемента. Для настройки используется <a href="#Редактор шаблонов">редактор шаблонов</a>.</p>
        </li>
      </ul>
    </Content>

    <SubHeader>Тип контента</SubHeader>
    <Content>
      <p>Пользователи и создатели могут добавлять контент различных типов. Каждый тип контента создаётся в своём уникальном редакторе.</p>
      <p>У любого созданного контента всегда есть дата создания, автор, раздел и <a href='#Тэг'>тэги</a>.</p>

      <SubSubHeader>Видео</SubSubHeader>
      <p>Самый ресурсоёмкий тип контента. Пользователь может загрузить файл, выбрать его начало и конец для обрезки. К видеофайлу можно добавить произвольное количество <a href="#Интерактив">интерактива</a>.</p>

      <SubSubHeader>Текст</SubSubHeader>
      <p>Простой для хранения, но сложный в разработке. Для редактирования текста мы предоставим WYSIWYG (What You See Is What You Get) редактор позволяющий добавлять в текст форматирование, делить текст на логические блоки и добавлять заголовки (из которых автоматически строится оглавление). Некоторые части текста можно скрывать и давать разблокировать за коины. В текст можно добавлять такие интерактивные части как «Скрытие», «Переход», «Опрос», «Вопрос», «Результат опроса». Настройки интерактива аналогичны встречающимся в видео, но не включают в себя всё что связано с влиянием на проигрывание.</p>

      <SubSubHeader>Аудиозапись</SubSubHeader>
      <p>Пользователи с правами добавления загружают аудиозаписи. Доступны все виды интерактива из видео, с учётом того что видеоряд обычно отсутствует.</p>

      <SubSubHeader>Изображение</SubSubHeader>
      <p>Изображения могут быть как фотографиями, так и рисунками. Из интерактива доступны только гиперссылки. На основе изображений можно делать интересные квесты.</p>
      <p>Есть возможность загружать несколько фотографий\рисунков в один элемент контента. В таком случае получается фотоальбом.</p>
    </Content>
    <SubHeader>Редактор шаблонов</SubHeader>
    <Content>
      Редактор шаблонов — это смесь html редактора и шаблонных переменных. Нет смысла упрощать шаблонный редактор и делать WYSIWYG. Шаблонный редактор используется только людьми обладающих достаточными знаниями. Для людей без знаний необходимых для свободного использования шаблонного редактора — в системе будут предусмотрен выбор из заранее заготовленных шаблонов.
    </Content>

    <SubHeader>Структура из макетов</SubHeader>
    <Content>
      <p>Вышеописанных элементов должно быть достаточно для реализации структуры соответствующей макетам.</p>
      <ol>
        <li>На верхнем уровне представлены разделы проектов</li>
        <li><p>Следующий уровень — подразделы по типу контента.</p><p>Настройка сортировки подразделов — по популярности.</p><p>На <a href={'#Предварительный просмотр раздела'}>обложках</a> присутствует:</p>
          <ul><li>предпросмотр одного самого популярного контента</li>
            <li>описание раздела, самые популярные активности</li>
            <li>самые популярные теги и топ контента по популярности.</li>
          </ul>
        </li>
        <li>Третий уровень — набор из преднастроенных подразделов:
          <ul>
            <li>Самые популярные элементы контента</li>
            <li>Рейтинги — включает в себя разделы с различной сортировкой. На обложке выводятся названия сортировок и топовые элементы из них</li>
            <li>Темы — самые популярные теги в популярных работах → уходит в четвёртый уровень</li>
            <li>Лидеры — раздел-сортировка по создателям популярного контента.</li>
            <li>В этот раздел включена панель <a href='#Модератор'>модераторов</a>.</li>
          </ul>
        </li>
        <li>
          <p>Четвёртый уровень. Динамические разделы названные тегами, упорядочены по популярности входящего в группу контента.</p>
          <p>При переходе в сгенерированный раздел — пользователь может просматривать все видео этого раздела упорядоченные по популярности. При просмотре всех элементов контента — можно видеть предпросмотр, название, описание, рейтинг, дату и автора.</p>
        </li>


      </ol>

    </Content>

    <SubHeader>Тэг</SubHeader>
    <Content><p>Тэг — это набор символов позволяющий каталогизировать контент вне рамок разделов. Тэги всегда могут быть добавлены во множественном числе. Система поддерживает поиск и фильтрацию всего контента по тегам.</p></Content>

  </div>;
  return dom;
};

export {Portal};