import { DropdownField } from "cmp/dropdownField/DropdownField.jsx";
import { PlainSelect } from "cmp/PlainSelect/PlainSelect.jsx";
import { Checkbox } from "cmp/Checkbox/Checkbox.jsx";
import { Radio } from "cmp/Radio/Radio.jsx";

var s = window.s = new Store({
  size: '',
  codec: 1,
  framerate: 0,
  time: 0,

  filesize: 0,
  filesize2: 0,
  filesize3: 0,
  perDay: 0,
  simult: 0,
  popularity: 0,
  creating: 0,

  useInterlacing: false,
  calculation: 'tv-show',
  backups: 0,
  duration: 0,
  dc: 0
});

var {
  size,
  codec,
  framerate,
  time,

  filesize,
  filesize2,
  filesize3,
  perDay,
  simult,
  popularity,
  creating,
  useInterlacing,
  calculation,
  backups,
  duration,
  dc
} = s.bindings();
var AWSPrice = function(gb) {
  if(gb<1024*50)
    return 0.023;

  if(gb<1024*450)
    return 0.022;


  return 0.021;
};
var moneyFormatter = function(num) {
  var strNum = num+'';
  var i,
    out = [],
    _i = strNum.length,
    count = (_i%3)||3,
    last = count;

  out.push(strNum.substr(0, count));
  count = 3;
  for(i = last; i < _i; i+=3){
    out.push(strNum.substr(i, count))
  }
  return out.join(',');
};
var GBFormatter = function(gb) {
  if(gb-0 < 1024){
    return (gb-0).toFixed(2)+'GB';
  }
  gb/=1024;
  if(gb-0 < 1024){
    return (gb-0).toFixed(2)+'TB';
  }
  gb/=1024;
  //if(gb-0 < 1024){
    return (gb-0).toFixed(2)+'PB';
  //}
}
var sizeSelector;
var Info = function(cfg, children) {
  return D.div({cls: 'info'}, children)
};
var Note = function(cfg, children) {
  cfg = cfg || {};
  return D.div({cls: D.cls('note', {'note-float': cfg.float})}, children)
};
var Header = function(cfg, children) {
  return D.div({cls: 'header'}, children)
};
var SubHeader = function(cfg, children) {
  return D.div({cls: 'subHeader'}, children)
};
var Field = function(cfg, children) {
  if(children[0].name === 'radio' || children[0].name === 'checkbox'){
    return <div className={'field'}><label>{children} <span class='field-label'>{cfg.label}</span></label></div>
  }else{
    return <div className={'field'}><label><span class='field-label'>{cfg.label}</span> {children}</label></div>
  }
};
var VideoCalculator = <div class={'calculator'}>
  Видеосервис.

  <Info>
    <p>
      Видеосервис должен позволять загружать видео в популярных форматах.
    </p>
    <p>
      После загрузки видеосервер должен автоматически запускать процесс перекодирования видеопотока в форматы подходящий для передачи через интернет в браузеры и smartTV.
    </p>
    <p>
      Обязательно должно производиться кодирование в видеофайлы с пониженным битрейтом для передачи пользователям не имеющим широкого канала интернет соединяния или оплачивающим траффик.
    </p>
  </Info>

  <Note>
    Интерактивные калькуляторы позволяют донести информацию наглядным образом и обеспечивают прозрачность
  </Note>

  <Header>
    Хранение и передача видео
  </Header>
  <SubHeader>
    Калькулятор размера видеофайла
  </SubHeader>

  <div class={'field'}><label>Разрешение видео: {sizeSelector = <PlainSelect value={size} map={(val)=>({w: val.split('x')[0]-0, h: val.split('x')[1]-0})} values={`
    256x144
    426x240
    640x360
    854x480
    >1280x720
    1920x1080
    2560x1440
    3840x2160
    7680x4320
  `}/>}</label></div>
  {_=>{
    sizeSelector.values.get().forEach(item=> {
      s.set( 'use-' + item.id.split( 'x' )[ 1 ], true );
    })
  }}
  <div class={'field'}><label>Используемый кодек: <PlainSelect value={codec} map={Number} values={`
    180: H.264 High quality
    >340: H.264 Medium quality
    675: H.264 Low quality
  `}/></label></div>

  <div className={'field'}><label>Кадров в секунду: <PlainSelect value={framerate} map={Number} values={`
    24
    30
    >60
    120
    240
  `}/></label></div>


  <div className={'field'}><label>Продолжительность серии: <PlainSelect value={time} map={Number} values={`
    15: 15 минут
    >30: 30 минут
    60: 1 час
    120: 2 часа
    135: 2 часа 15 минут
  `}/></label></div>


  {_=>s.sub([size, codec, framerate, time], (size, codec, framerate, time)=>{
    var [w,h] = size.split('x');
    filesize.set((w*h*3/codec*framerate*time*60 / 1024 / 1024 / 1024).toFixed(2));
  })}


  <div className={'field'}>Размер видеофайла: {GBFormatter(filesize)}</div>

  <SubHeader>
    Интерлейсинг
  </SubHeader>

  <Info>
    Технология широко использовалась во времена дисплеев основанных на лучевых трубках — чередовались кадры с чётными и нечётными строками. Позволяет получить двойной выигрыш по объёму файлов за счёт ухудшения качества картинки.
  </Info>

  <img src="https://blog.video.ibm.com/wp-content/uploads/2016/03/interlace-soccer2-1024x394.jpg" style="display: block;margin: auto;"/>



  <div className={'field'}><label><Checkbox value={useInterlacing}/> Использовать интерлэйсинг</label></div>

  {_=>s.sub([useInterlacing, filesize], (useInterlacing, filesize)=>{
    filesize2.set(useInterlacing ? filesize/2 : filesize);
  })}

  {_=>s.sub([size, codec, framerate, time, 'filesize3', useInterlacing,
    'use-144', 'use-240', 'use-360', 'use-480', 'use-720', 'use-1080', 'use-1440', 'use-2160', 'use-4320'], (size, codec, framerate, time, filesize3, useInterlacing)=>{
    var downscales = [],
        vals = sizeSelector.values.get();
    for( var i = 0, _i = vals.length; i < _i; i++ ){
      var [w,h] = vals[ i ].text.split('x');

      downscales.push({p: h, size: (w*h*3/codec*framerate*time*60 / 1024 / 1024 / 1024).toFixed(2)});

      if(vals[ i ].id === size){
        break;
      }
    }

    if(downscales.length>1){

      s.set('filesize3', (downscales.map(item=>s.get('use-'+item.p)?item.size-0:0).reduce((a,b)=>a+b)  * (useInterlacing ? 0.5 : 1)).toFixed(2));

      _(<div><SubHeader>Объём необходимый для хранения различных форматов</SubHeader>
        <Note float>форматы которые не нравятся можно выключить</Note>
        <table>
            <tr class={'thead'}>
              <td></td>
              <td>Формат</td>
              <td>Объём</td>
            </tr>
            {downscales.map(item=><tr>
              <td><Checkbox value={s.bind('use-'+item.p)}/></td>
              <td>{item.p}p</td>
              <td>{GBFormatter(item.size * (useInterlacing ? 0.5 : 1))}</td>
            </tr>)}
            <tr class={'summary'}>
              <td colSpan={3}>
                Всего <b>{GBFormatter(s.get('filesize3'))}</b> на серию
              </td>
            </tr>
        </table>


      </div>);

      console.log(s.get('filesize3'));
    }else{
      s.set('filesize3',  (downscales[0].size * (useInterlacing ? 0.5 : 1)).toFixed(2));
      _(<div>Объём необходимый для хранения одного выпуска: {GBFormatter(s.get('filesize3'))}</div>);
    }

  })}
  <SubHeader>Выберите тип расчёта</SubHeader>
  <Field label='Сериальный'><Radio value='tv-show' group={calculation}/></Field>
  <Field label='Видеоплатформенный'><Radio value='ott' group={calculation}/></Field>

  {_=>{
    calculation.sub(val=>{
      if(val === 'tv-show'){
        _(<div>
          <Header>Сериальный расчёт</Header>
          <SubHeader>Планируемая частота и количество шоу</SubHeader>

          <div className={'field'}><label>Одновременно выходят: <PlainSelect value={simult} map={Number} values={`
            1: Одно шоу
            2: Два шоу
            >5: Пять шоу
            10: Десять шоу
            50: Сорок шоу, некоторые разветвились и получлось 50
            100: Шоу, челленджи, платформа популярна, но не на весь мир
          `}/></label></div>

          <div class={'field'}><label>Новая серия выходит: <PlainSelect value={perDay} map={Number} values={`
            1: Каждый день
            >7: Каждую неделю
            30: Каждый месяц
            28: Сезон из 13 серий USA\Canada standard
            16.5: Сезон из 13 серий USA\Canada standard
          `}/></label></div>
        </div>);
      }else if(val === 'ott'){
        _(<div>
          <Header>Расчёт для видеоплатформы</Header>
          <Info>На основе <a href="https://merchdope.com/youtube-stats/#:~:text=The%20total%20number%20of%20people,on%20Youtube%20every%20single%20day.&text=In%20an%20average%20month%2C%208,49%20year%2Dolds%20watch%20YouTube" target='_blank'>статистики по ютубу за 2020 год</a> и
             доступных публичных данных <a href="https://www.similarweb.com/top-websites">от similarweb</a> были выстроены примерные оценки нагрузки на хранилища файлов для различных видеосервисов.
          </Info>
          <Field label={'Популярность'}>
            <PlainSelect value={popularity} map={Number} values={`
              300: YouTube. 300 hours of video uploaded every minute. Traffic: 33.39B
              25: Pornhub. 25 hours of video uploaded every minute (scaled). Traffic: 2.85B
              1.19: Vimeo. 1.19 hours of video uploaded every minute (scaled). Traffic: 133.7M
              0.1: Traffic: 10M Good globally known platform. 8 minutes of video per minute
              0.0125: Traffic: 1M. Good local OTT platform. 1 minute of video per minute
              >0.002: Netflix 90000 minutes of original video in 2018 year
            `}/>
          </Field>

        </div>);
      }
    })
  }}



  <SubHeader>Расчёт требуемого для хранения данных места</SubHeader>

  <p>
    Расчитаем нарастающий объём данных на дисках.
  </p>
  <Field label={'Временной промежуток'}>
    <PlainSelect value={duration} map={Number} values={`
      1:1 month
      12: 1 year
      >24: 2 year
      36: 3 year
      48: 4 year
      60: 5 year
    `}/>
  </Field>

  <p>
    Будем считать что наполнение происходит линейно
  </p>

  <Field label={'Хранение бэкапов'}>
    <PlainSelect value={backups} map={Number} values={`
      0: Мы не храним бэкапов!
      1: RAID 10. Дублирование всех записанных данных
      >0.3: RAID 3. Отдельный диск для битов чётности. Минимум 4 диска
      2: Кворум из трёх машин. Обычно используется для финансовых БД
    `}/>
  </Field>

  <Note>
    <p>
      На первых этапах (демонстрация, первые 6 месяцев) можно раздавать контент с одного сервера.
    </p>
    <p>
      Далее можно взять несколько серверов в оптимальных местах (европа, северная и южная америка, азия, западная и восточная Россия).
    </p>
    <p>
      Но при серьёзном масштабировании OTT платформы нужно будет обязательно выбрать подходящее CDN решение или построить своё.
    </p>
    <p>
      CDN позволяет как экономить международный траффик между клиентом и сервером раздающим видео, так и снять нагрузку с ключевых элементов инфраструктуры.
    </p>
    <p>
      Много пользователей из Америки одновременно смотрящих премьеру передачи с европейского сервера способны существенно забить трансокеанические кабели передачи данных, или, как минимум, сделать его использование нерентабельным.
    </p>

  </Note>
  <Field label={'Датацентры'}>
    <PlainSelect value={dc} map={Number} values={`
      0: Не нужен
      >2: Разворачиваем 3 своих датацентров
      5: Разворачиваем 6 своих датацентров
    `}/>
  </Field>

  <Note>
    <p>
      На больших объёмах основными потребителями ежемесячного бюджета становятся сервера и оплата траффика. Траффик напрямую зависит от количества пользователей платформы.
    </p>
    <p>
      Дальнейшие вычисления нагрузки будут произведены с учётом самого популярного разрешения видео 720p
    </p>
  </Note>
  <Field label={'Пользователей в месяц '}>
    <PlainSelect value={dc} map={Number} values={`
      0: Нет пользователей 
      20: 20 — Тестирование платформы 
      500: 500 — Ранний запуск
      4000: 4000 — Набирает популярность
      10000: 10000 — Набирает популярность
      
      180000000: 180 000 000 — Аудитория Netflix
      500: 500 — Ранний запуск
      5: Разворачиваем 6 своих датацентров
    `}/>
  </Field>

  {_=>{
    s.sub([


      duration,
      backups,
      calculation,

      simult, perDay,
      popularity,
      time,
      filesize3, dc
    ], (

      duration,
      backups,
      calculation,

      simult, perDay,
      popularity, time,
      filesize3, dc)=>{

      var origDate = +new Date(),
          d = origDate,
          lastDate = d,
          slices = [],
          stored = 0;
      for(var i = 0; i < duration; i++){
        d = new Date(d);
        d.setMonth(d.getMonth()+1);

        var slice = {date: d},
            newData;
        if(calculation === 'ott'){
          newData =
            (filesize3/time)* // minute size
            (((+d)-(+lastDate))/1000/60)* // minutes in month
            popularity*60;
        }else{
          newData = filesize3*simult*(((+d)-(+lastDate))/1000/60/60/24 / perDay)
        }
        newData+=newData*backups;
        newData+=newData*dc;
        stored += newData;
        slice.stored = stored;
        slice.newData = newData;
        lastDate = d;
        slices.push(slice);
      }

      _(<table>
        <tr className={'thead'}>
          <td>Дата</td>
          <td>Объём</td>
          <td>AWS Storage</td>
          <td>AWS Data Transfer</td>
        </tr>
        {slices.map(slice=><tr>
          <td>{slice.date.getMonth() +' '+ slice.date.getFullYear()}</td>
          <td>{GBFormatter(slice.stored)}</td>
          <td>${moneyFormatter((slice.stored*AWSPrice(slice.stored))|0)}/month</td>
          <td>${moneyFormatter((slice.stored*AWSPrice(slice.stored))|0)}/month</td>
        </tr>)}
      </table>);



    });
  }}

  2020 June | 100 Tb
  2020 Jule | 200 Tb
  2020 August | 300 Tb

  Таблица, график, стоимость у амазона


  Netflix использует для хранения Amazon AWS

  <Info>
    <a href="https://medium.com/refraction-tech-everything/how-netflix-works-the-hugely-simplified-complex-stuff-that-happens-every-time-you-hit-play-3a40c9be254b">
      Здесь можно почитать о том как строится инфраструктура подобная Netflix
    </a>
  </Info>


  USE: https://www.wowza.com/products/streaming-engine/deployment-options



</div>;

export {VideoCalculator};