import { Info, Content, Note, Header, SubHeader, Field, SubSubHeader } from '/cmp/Blocks.jsx';

import { PlainSelect } from "cmp/PlainSelect/PlainSelect.jsx";
import { Checkbox } from "cmp/Checkbox/Checkbox.jsx";
import { Radio } from "cmp/Radio/Radio.jsx";
import { Input } from "cmp/Input/Input.jsx";
import { TimeInput } from "cmp/TimeInput/TimeInput.jsx";
import { NumberInput } from "cmp/NumberInput/NumberInput.jsx";

import Add from "/svg/ic_add.svg";
import "./Users.scss";
import { Collapse } from "cmp/Collapse/Collapse.jsx";


var Users = function(){
  s.set( {} );
  var dom = <div class={'users'}>
    <Header>Пользователи</Header>

    <SubHeader>
      Поведенческий анализ
    </SubHeader>
    <Content>
      <p>
      Разрабатываемая система производит постоянное отслеживание поведения пользователей. Накопленные поведенческие данные могут обрабатываться с помощью Data Mining и Machine Learning алгоритмов.
      </p>
      <p>
        Мы обеспечиваем прямую связь между зрителями и создателями контента. Создатели могут как оценивать такие статистические данные как количество просмотров видео, наиболее полпулярные видео и разделы, так и напрямую обратиться к зрителю и спросить о том что нравится в шоу, а что нет; устраивать опросы и розыгрыши призов.
      </p>
    </Content>
    <SubHeader>
      Кросс-платформенная связь
    </SubHeader>
    <Content>
      <p>
        Основной платформой для просмотра видеоконтента является телевизор, но последнее время всё больше пользователей использует мобильный телефон или персональный компьютер в качестве устройства для доступа к видео информации. Это легко объясняется тем, что интернет сервисы, такие как youtube, дают зрителю возможность выбирать контент для просмотра по своему желанию, а не основываясь на предварительно составленной сетке показов телеканала.
      </p>
      <p>
        Наша цель — объединить эти два мира. Вернуть пользователю удобство восприятия видеоинформации с большого экрана и обеспечить выбор желаемого контента.
      </p>
      <p>
        <i>Интерактивная часть</i>. Обратная связь, опросы, конкурсы и все другие места где от пользователя требуется ввод информации — не удобно использовать с телевизора. Пульт как правило не имеет достаточно кнопок для удобного ввода текстовой информации. По этой причине мы решили объединить SmartTV и мобильное вебприложение в единую синергитическую систему. Отвечать на вопросы и предлагать свои варианты развития сюжета можно с удобной мобильной клавиатуры. Или даже с клавиатуры своего ноутбука!
      </p>
    </Content>

    <SubHeader>
      Регистрация
    </SubHeader>
    <Content>
      <p>
    Первоначальная регистрация пользователей происходит при установке мобильного приложения или при открытии smartTV приложения.
      </p>
      <p>
    Заполнение персональных данных не обязательно, но подкрепляется положительными мотиваторами (день просмотра без рекламы, получение мир-коинов*?).
      </p>
    </Content>

    <SubHeader>
      Слияние аккаунтов
    </SubHeader>
    <Content>
      <p>
        Система должна предусматривать возможность слияния пользователей для объединения случайно созданых разных профилей мобильного и smartTV приложений.
      </p>
      <p>
        Для слияния пользователей и\или авторизации необходимо отсканировать мобильным телефоном QR-код с телевизора.
      </p>
    </Content>

    <SubHeader>
      Вход в существующий аккаунт
    </SubHeader>
    <Content>
      <p>
          Вход в существующий аккаунт с устройства не поддерживающего сканирование QR-кода (компьютер) возможен только при:
      </p>
      <ul>
        <li>
    прохождении двуфакторной авторизации с мобильного устройства
        </li>
        <li>
    прохождении авторизации по смс
        </li>
        <li>
    прохождении авторизации по email
        </li>
        <li>
    при изначальном создании аккаунта из web версии приложения
        </li>
      </ul>
      <p>
    При изначачальном создании аккаунта из web версии - дальнейшая авторизация на телевизоре происходит с помощью сканирования мобильным приложением QR-кодов web версии и smartTV версии приложения МИР.
      </p>
    </Content>

    <SubHeader>
      Поощрение
    </SubHeader>
    <Content>
      <p>
        Нам выгодно заполнение как можно более подробное заполнение профиля пользователя. Введённые данные дают нам возможность производить точное таргетирование отображаемой рекламы и рекомендуемого контента.
      </p>
      <p>
        После заполнения username, email и phone number — у пользователя появляется кошелёк.
      </p>
      <p>
        По этой причине за заполнение профиля мы даём пользователю награду в виде МИР-коинов.
      </p>
      <p>
      Распоряжение коинами происходит с мобильного приложения с использованием двуфакторной авторизации. Второй фактор может быть email, sms или сканирование QR кода с телевизора.
      </p>
      <p>Дополнительная информация о поощрениях представлена в разделе «<a href="#Монетизация">монетизация</a>».</p>
    </Content>

    <SubHeader>Права доступа</SubHeader>
    <Content>
      <p>Над каждым объектом в системе можно выполнять следующие действия:</p>
      <ul>
        <li>Создавать</li>
        <li>Изменять</li>
        <li>Удалять</li>
        <li>Наполнять</li>
        <li>Просматривать</li>
      </ul>
      <p>Каждый пользователь может выполнять различный набор этих действий над каждым объектом в системе.</p>

    </Content>
    <SubHeader>Группы</SubHeader>
    <Content>
      <p>Пользователь может быть включен в группу.</p>
      <p>В группе может содержаться от нуля пользователей.</p>
      <p>Права доступа к объекту могут назначаться группе.</p>
    </Content>

    <SubHeader>Роли</SubHeader>
    <Content>
      <p>Для упрощения настройки доступа мы предопределили стандартные комбинации прав доступа</p>
      <SubSubHeader>Создатель</SubSubHeader>
      <p>Создал объект. Может изменять, удалять, просматривать и наполнять его. Может выдавать доступ на эти действия другим пользователям и группам.</p>

      <SubSubHeader>Администратор</SubSubHeader>
      <p>Обладает теми же возможностями что и создатель, кроме удаления.</p>

      <SubSubHeader>Модератор</SubSubHeader>
      <p>Может редактировать описание раздела, обложку раздела, содержимое раздела. Может выдавать права на просмотр и наполнение другим пользователям и группам.</p>

      <SubSubHeader>Автор</SubSubHeader>
      <p>Наполняет раздел. Может удалять, редактировать свой контент и комментарии к нему.</p>
    </Content>

  </div>;
  return dom;
};

export {Users};