import { Info, Content, Note, Header, SubHeader, Field, SubSubHeader } from '/cmp/Blocks.jsx';

import { PlainSelect } from "cmp/PlainSelect/PlainSelect.jsx";
import { Checkbox } from "cmp/Checkbox/Checkbox.jsx";
import { Radio } from "cmp/Radio/Radio.jsx";
import { Input } from "cmp/Input/Input.jsx";
import { TimeInput } from "cmp/TimeInput/TimeInput.jsx";
import { NumberInput } from "cmp/NumberInput/NumberInput.jsx";

import Add from "/svg/ic_add.svg";
import "./Profit.scss";
import { Collapse } from "cmp/Collapse/Collapse.jsx";


var Profit = function(){
  s.set( {} );
  var dom = <div class={'profit'}>
    <Header>Монетизация и система вознаграждения</Header>
    <SubHeader>Кошелёк пользователя</SubHeader>
    <Content>
      <p>
      Каждому пользователю системы заполнившему в своём профиле имя, фамилию и телефон становится доступен личный кошелёк с МИР-коинами.
      </p>
      <p>
        Кошелёк — это транзакционная структура. Транзакционность означает что действие с кошельком может быть либо выполнено, либо не выполнено. Не может быть частичного выполнения действия. Если при попытке выполнения действия с балансом (оплата, пополнение, перевод) происходит ошибка — все произведённые в процессе изменения откатываются к начальному состоянию.
      </p>
      <p>
        В кошельке можно как просмотреть список всех проведённых операций, так и запросить агрегацию данных за определённый промежуток времени.
      </p>
    </Content>
    <SubHeader>Вознаграждения</SubHeader>
    <Content>
      <p>Каждое действие в системе может быть вознаграждено.</p>
      <p>Размер награды выставляет автор контента и интерактива.</p>
      <p>Награда списывается со счёта автора и поступает к пользователю выполнившему действие.</p>
      <p>Автор может указать максимальный <i>бюджет интерактива</i>, при выходе за который происходит одно из следующих поведений (в зависимости от настройки):
      <ul>
        <li>Интерактив становится не активен</li>
        <li>Бюджет начинает делиться между всеми учавстваовашими пользователями с учётом новых проголосовавших (это очень сложная с точки зрения балансировки опция)</li>
        <li>Интерактив остаётся, но за участие в нём даётся только платформенная награда за участие</li>
      </ul></p>
      <p>Платформа тоже раздаёт коины для поощрения активности пользователей.</p>
      <p><i>Кошелёк платформы</i> не имеет ограничений, но транзакции с него учитываются точно так же, как и при всех остальных переводах. Можно сказать что системный кошелёк — кредитный.</p>
    </Content>

    <SubHeader>Монетизация</SubHeader>
    <Content>
      <p>Монетизация платформы строится на реальном вводе денег в систему со стороны следующих акторов:
      <ul>
        <li>Рекламодатели и пользователи — могут выкупать МИР-коины на бирже за настоящие деньги.</li>
        <li>Крупные поставщики контента — покупают МИР-коины по партнёрским договорённостям.</li>
      </ul></p>
      <p>При капитализации платформы — отрицательная часть баланса основного кошелька подкрепляется деньгами и платформа начинает выкупать МИР-коины на бирже на сумму равную:</p>
      <center><b>пришедшие средства – налоги – обслуживание – процент нормы прибыли</b></center>

        <SubSubHeader>Биржа</SubSubHeader>
      <p>
        Биржа представлена простой торговой площадкой с графиком динамики обменного курса (свечной график).
      </p>
      <p>Любой пользователь системы может установить ордер на покупку или продажу МИР-коинов. Или нажать «купить по текущему курсу».</p>
      <p>Как и любая биржа — будем брать процент за обмен, например, 0.02%.</p>
      <p>Пример визуального отображения биржи</p>
<img src='trade.PNG' style={{width: '100%'}}/>

    </Content>
  </div>;
  return dom;
};

export {Profit};