import {Component} from 'cmp/Component.jsx';


var Input = new Component({
  name: 'Input',
  ctor: function(cfg) {
    Object.assign(this, cfg);

    this.createDOM();
    this.initBinding();

    this.afterInit && this.afterInit();
  },
  prop: {
    value: {type: String, default: false}
  },
  createDOM: function() {
    var val = this.value,
      el = this.dom = this.inputEl = D.h('input', {
        attr: {type: 'text'},
        cls: 'cmp-input',
        oninput: function() {
          val.set(el.value);
        }
      });

    this.afterDOM && this.afterDOM();
  },
  initBinding: function() {
    var _self = this;

    this.sub([this.value], function (val) {
      _self.inputEl.value = val;
    });

  }
});

export { Input };
