import {Component} from 'cmp/Component.jsx';
import './Collapse.scss';
var Collapse = new Component({
  name: 'Collapse',
  ctor: function(cfg) {
    Object.assign(this, cfg);

    this.createDOM();


    this.afterInit && this.afterInit();
  },
  prop: {
    value: {type: Boolean, default: false},
    label: {type: String, default: 'Collapse'},
  },
  createDOM: function() {
    var val = this.value,
      el = this.dom = this.inputEl = D.h('div', {
          cls: D.cls('cmp-collapse', {
            collapsed: val
          })
        },
      D.div({cls: 'cmp-collapse-title', onclick: function(){ val.set(!val.get())}}, this.label),
      D.div({cls: 'cmp-collapse-content'}, this.children)
    );

    this.afterDOM && this.afterDOM();
  }
});

export { Collapse };