import {Component} from 'cmp/Component.jsx';

var Radio = new Component({
  ctor: function() {
    this.createDOM();
    this.initBinding();

    this.afterInit && this.afterInit();
  },
  prop: {
    value: {type: Component.Property.Any, default: false},
    group: {type: Component.Property.Any, default: false}
  },
  createDOM: function() {
    var val = this.value,
      group = this.group,
        el = this.dom = this.inputEl = D.h('input', {
          attr: {type: 'radio'},
          cls: 'picker-button__field',
          onchange: function() {
            if(el.checked){
              group.set(val.get())
            }
          }
        });

    this.afterDOM && this.afterDOM();
  },
  initBinding: function() {
    var _self = this;

    this.sub([this.value, this.group], function (val, group) {
      _self.inputEl.checked = val === group;
    });
  }
});

Radio.prototype.name = 'radio';
export { Radio };