import {Info, Content, Note, Header, SubHeader, Field} from '/cmp/Blocks.jsx';

import { PlainSelect } from "cmp/PlainSelect/PlainSelect.jsx";
import { Checkbox } from "cmp/Checkbox/Checkbox.jsx";
import { Radio } from "cmp/Radio/Radio.jsx";
import { Input } from "cmp/Input/Input.jsx";
import { TimeInput } from "cmp/TimeInput/TimeInput.jsx";
import { NumberInput } from "cmp/NumberInput/NumberInput.jsx";

import Add from "/svg/ic_add.svg";
import "./Interactive.scss";
import { Collapse } from "cmp/Collapse/Collapse.jsx";


var Interactive = function() {
  s.set({
    interactive: {
      example1: {

        selected: false,
        name: 'Опрос 1',
        from: 30,
        to: 90,
        now: 0,
        title: 'Что это летает?!',
        x: 20,
        y: 15,
        width: 60,
        height: 60,
        added: false,
        options: [
          'Рыба',
          'Азатот'
        ],
        'in': {
          time: 1,
          animation: 'style1'
        },
        'out': {
          time: 1,
          animation: 'style1'
        }
      }
    }
  });
var step = function(e) {
  var stepEl = D.findParent(e.target, el=>el.classList.contains('step'));
  if(stepEl){
    var steps = [].slice.call(document.querySelectorAll('.step')),
      stepID = steps.indexOf(stepEl);

    var bound = steps[stepID+1].getBoundingClientRect();
    steps[stepID+1].style.height = 0;

    setTimeout(function() {
      steps[stepID+1].style.height = bound.height + 'px';
    }, 10);

    //debugger
    D.insertAfter(steps[stepID+1], stepEl);
  }
};
var _now, vid,
  dom = <div class={'interactive'}>
    <Header>Интерактив</Header>
    <Content>
      <p>Возможность взаимодействия со зрителем отличает платформу от всех других продуктов доминирующих на рынке видеосервисов.</p>
      <p>Мы предлагаем создателям контента получать моментальную обратную связь в виде голосований, разветвлений сюжета, конкурсов. На базе нашей платформы можно даже устроить розыгрыш призов или провести начальное тестирование для поступающих в вуз!</p>
    </Content>

    <SubHeader>Редактор интерактива</SubHeader>
    <Content>
      <p>
        Интерфейс редактора позволяет добавлять интерактивные элементы и настраивать их. Рассмотрим на примере добавления опроса. Функционал не доступен в примере будет иметь серую подложку.
      </p>
      <p class='step'>
        Запустим видео и найдём подходящий момент
        <button class={'act'} onClick={e=>{vid.play();step(e);}}><img src={'play.png'}/></button>
      </p>
    </Content>

    <div style='display: flex' class={D.cls('editor', {
      notAdded: s.valEqual('interactive.example1.added', false)
    })}>
      <div style='display: flex;flex-direction: column;'>
        <div style='position: relative'>
        {vid = <video width="500" controls ontimeupdate={(e)=>{
          s.set('interactive.example1.now', e.target.currentTime);
          _now.style.left = e.target.currentTime/(3*60+20)*100+'%';
        }}>
          <source src="fish.mp4" type="video/mp4"/>
          Your browser does not support the video tag.

        </video>}
        <div class={D.cls('quiz', s.val('interactive.example1.style'))} style={{
          left: T.concat( s.val('interactive.example1.x'), '%'),
          top: T.concat( s.val('interactive.example1.y'), '%'),
          height: T.concat( s.val('interactive.example1.width'), '%'),
          width: T.concat( s.val('interactive.example1.height'), '%'),
          opacity:  _=>{
            s.sub([
              'interactive.example1.from',
              'interactive.example1.in.time',
              'interactive.example1.to',
              'interactive.example1.out.time',
              'interactive.example1.now'
            ], (f, ft, t, tt, n)=>{
              if(n >= f && n <= t)
                return _(1);
              if(n<f-ft || n > t + tt)
                return _(0);
              if(n<f)
                return _((f-n)/ft);

              return _((t+tt-n)/tt);

            })
          }
        }}>
          <div class={'title'}>{s.val('interactive.example1.title')}</div>

          <div className='answer'>{s.val('interactive.example1.options.0')}</div>
          <div className='answer'>{s.val('interactive.example1.options.1')}</div>
        </div>
        </div>
        <div class={'bottom-panel'}>
          <div style='display: flex'>
            <div class="timelines-list" style='width:120px'>
              <div class={'add-button'}><Add/> Добавить
                <div class={'inner'}>
                  <div class={'add-submenu'}><button onClick={()=>{
                    s.set('interactive.example1.from', vid.currentTime|0);
                    s.set('interactive.example1.to', vid.currentTime + 30|0);
                    s.set('interactive.example1.added', true);

                  }}>Опрос</button></div>
                  <div class={'not-implemented'} style={{display: 'block'}}>
                    <div class={'add-submenu'}>
                      <button>Вопрос</button>
                    </div>
                    <div class={'add-submenu'}>
                      <button>Загадка</button>
                    </div>
                    <div class={'add-submenu'}><button>Переход</button></div>
                    <div class={'add-submenu'}><button>Разветвление сюжета</button></div>
                    <div class={'add-submenu'}><button>Результат опроса</button></div>
                    <div class={'add-submenu'}><button>Виджет</button></div>
                  </div>
                </div>
              </div>
              <div class={'item'}>{s.val('interactive.example1.name')}</div>

            </div>
            <div class={'timeline-panel'}>
              <div class={'timeline-title'}>
                Timeline
              </div>
              <div class="timelines-bounds-list">
                {_now = <div class={'time-now'}></div>}
                {_=>{
                  var d;
                  _(d = <div class='kolbasa'>опрос</div>);
                  s.sub(['interactive.example1.from', 'interactive.example1.to'], (f,t)=>{
                    d.style.left = f/(3*60+20)*100+'%';
                    d.style.width = (t-f)/(3*60+20)*100+'%';
                  })
                }}
                <div class={'from'}>0:00</div>
                <div class={'to'}>3:20</div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div style='width:100%;position: relative;padding:4px 16px' class={'inputs'}>
        <Field label='Название' width={140}><Input value={s.bind('interactive.example1.name')}/></Field>

        <Field label={'Стиль'} width={140}>
          <PlainSelect value={s.bind('interactive.example1.style')} values={`
            style1: Стиль 1
            >style2: Стиль 2
            style3: Стиль 3
          `}/>
        </Field>

        <Collapse label={'Контент'} value={false}>
          <Field label='Заголовок' width={140}><Input value={s.bind('interactive.example1.title')}/></Field>

          <Field label='Ответ 1' width={140}><Input value={s.bind('interactive.example1.options.0')}/></Field>
          <Field label='Ответ 2' width={140}><Input value={s.bind('interactive.example1.options.1')}/></Field>

          <div class="not-implemented">+ Добавить ответ</div>


        </Collapse>
        <Collapse label={'Время'} value={true}>
          <Field label='Начало (сек)' width={140}><TimeInput value={s.bind('interactive.example1.from')}/></Field>
          <Field label='Конец (сек)' width={140}><TimeInput value={s.bind('interactive.example1.to')}/></Field>
        </Collapse>
        <Collapse label={'Позиция на экране'} value={true}>
          <Field label='Левый край %' width={140}><NumberInput value={s.bind('interactive.example1.x')}/></Field>
          <Field label='Верххий край %' width={140}><NumberInput value={s.bind('interactive.example1.y')}/></Field>
          <Field label='Ширина %' width={140}><NumberInput value={s.bind('interactive.example1.width')}/></Field>
          <Field label='Высота %' width={140}><NumberInput value={s.bind('interactive.example1.height')}/></Field>
        </Collapse>

        <Collapse label={'Анимации'} value={true}>

            <p>Эффект появления</p>
          <div className={'not-implemented'} style={{ width: '100%' }}>
            <Field label={'Стиль'} width={180}>
              <PlainSelect value={s.bind('interactive.example1.in.animation')} values={`
                >style1: Проявление
                style2: Вылет справа
                style3: Выпрыгивание
              `}/>
            </Field>
          </div>
            <Field label='Время анимации' width={180}><TimeInput value={s.bind('interactive.example1.in.time')}/></Field>

            <p>Эффект исчезновения</p>
          <div className={'not-implemented'} style={{ width: '100%' }}>
            <Field label={'Стиль'} width={180}>
              <PlainSelect value={s.bind('interactive.example1.out.animation')} values={`
                >style1: Растворение
                style2: Улёт налево
                style3: Ускакивание
              `}/>
            </Field>
          </div>
            <Field label='Время анимации' width={180}><TimeInput value={s.bind('interactive.example1.out.time')}/></Field>

        </Collapse>

      </div>
    </div>

    <Content>
      <p class='step'>
        Остановим видео в том месте где хочется добавить опрос
        <button class={'act'} onClick={e=>{vid.pause();step(e);}}><img src={'pause.png'}/></button>
      </p>
      <p class='step'>
        Для этого нужно навести на кнопку <img src={'add.png'}/> и выбрать «опрос» в появившемся списке.
      </p>

      <p class='step'>
        Пользователь добавляющий опрос сможет настроить положение опроса на экране, время появления и анимации. Написать заголовок опроса и добавить любое количество ответов.
      </p>
      <p class='step'>
        Многие параметры можно поменять и в этом интерактивном примере, но его цель — показать принцип.
      </p>
    </Content>

    <Header>
      Типы интерактива
    </Header>
    <SubHeader>
      Опрос
    </SubHeader>
    <Content>
      <p>
        <i>Выбор ответа из предложенных вариантов</i>.
      </p><p>
        Действие доступно как из приложения smartTV с помощью пульта, так и с мобильного телефона.
    </p><p>
      Настраивается позиция блока, количество и текст вариантов. При включенной опции "Свой вариант" - зритель получает возможность ввести свой текст.
      <Info>Можно реализовать сборку текста из заранее подготовленных кусочков. Это сильно упрощает анализ и группировку ответов пользователей, а так же на корню решает все проблемы с матом и модерацией. Пример такого ввода текста встречается в играх от From Software - Bloodborn и Dark Souls 1, 2, 3</Info>
    </p>
    </Content>

    <SubHeader>
      Вопрос
    </SubHeader>
    <Content>
      <p>
        Предлагает зрителю <i>ответить на вопрос</i>. Без вариантов ответов. Как и опрос, можно реализовать набор фразы из кусочков.
      </p>
      <p>
        Помимо стандартных настроек - можно задать минимальную\максимальную длину ответа.
      </p>
    </Content>

    <SubHeader>
      Загадка
    </SubHeader>
    <Content>
      <p>
        <i>Поле-чудес</i>, викторины, онлайн-кроссворды, судоку и любые другие конкурсы где ответ состоит из точного количества букв\знаков. Предлагает зрителю заполнить клеточки и угадать. В качестве награды зритель может получать валюту платформы, либо быть переданным организаторам шоу для возможности очно попасть в следующий тур или получить уникальные призы.
      </p>
      <p>
        Заполнять клетки ответа можно как с мобльного устройства, так и с пульта телевизора.
      </p>
      <p>
        Настраивается стиль клеток, их количество, расположение относительно друг друга и доступные для ввода символы\цвета или даже звуки (конкурс с подбором мелодии!)
      </p>
    </Content>
  </div>;


  return dom;
};
export {Interactive};