var Info = function(cfg, children) {
  return D.div({cls: 'info'}, children)
};
var Content = function(cfg, children) {
  return D.div({cls: 'content0'}, children)
};
var headers = [];
var Note = function(cfg, children) {
  cfg = cfg || {};
  return D.div({cls: D.cls('note', {'note-float': cfg.float})}, children)
};

var uniqLink = function(children) {
  var child = children[0];
  if(!child)
    return {};
  var title;
  if(child.dom instanceof HTMLElement){
    title = child.dom.innerText;
  }else if(child instanceof HTMLElement){
    title = child.innerText;
  }else{
    title = child;
  }
  return {name: title, title: title}
};

var Header = function(cfg, children) {
  var item = uniqLink(children);
  if(!cfg || !cfg.hidden)
    headers.push(Object.assign(item, {type: 'Header'}));
  return D.div({cls: 'header'}, [D.h('a', {attr: {name: item.name}})].concat(children))
};
var SubHeader = function(cfg, children) {
  var item = uniqLink(children);
  if(!cfg || !cfg.hidden)
    headers.push(Object.assign(item, {type: 'SubHeader'}));
  return D.div({cls: 'subHeader'}, [D.h('a', {attr: {name: item.name}})].concat(children))
};
var Field = function(cfg, children) {
  cfg = cfg || {};
  if(children[0].name === 'radio' || children[0].name === 'checkbox'){
    return <div className={'field'}><label>{children} <span class='field-label'>{cfg.label}</span></label></div>
  }else{
    var child = children[0];
    if(cfg.width && child){
      if(child.dom instanceof HTMLElement){
        child.dom.style.left = cfg.width+'px';
      }else if(child instanceof HTMLElement){
        child.style.left = cfg.width+'px';
      }

    }
    return <div className={'field'}><label><span class='field-label'>{cfg.label}</span> {children}</label></div>
  }
};

export {Info, Content, Note, Header, SubHeader, Field, headers};