
module.exports = {
    entry: './src/index.jsx',
    devtool: 'source-map',
    module: {
        rules: [
            {
                test: /\.(js|jsx)$/,
                exclude: /node_modules/,
                use: ['babel-loader']
            },
            {
                test: /\.tsx?$/,
                loader: 'babel-loader',
            },
        ]
    },
    resolve: {
        extensions: ['*', '.js', '.jsx', '.tsx','.ts']
    },
    output: {
        path: __dirname + '/dist',
        publicPath: '/',
        filename: 'bundle.js'
    },
    devServer: {
        contentBase: './dist'
    }
};