import {PropertySetterInterface, PropSettersInterface} from "./Rjsx";

const byPass = a => a;

export const Reactivity = function(args) {
    this.args = args;
};

Reactivity.prototype = {
    args: [],
    scope: null,
    key: null,
    fn: null,
    emit: function() {
        TaskManager.add(()=>{
            this.scope.setKey(this.key, this.fn.apply(this.scope, this.args));
        });
    }
};


export const TaskManager = {
    jobs: [],
    active: false,
    add: function(task) {
        TaskManager.jobs.push(task);
        if(!TaskManager.active) {
            TaskManager.active = true;
            requestAnimationFrame(TaskManager.work);
        }
    },
    work: function() {
        const jobs = TaskManager.jobs;
        TaskManager.jobs = [];
        TaskManager.active = false;

        for (let i = 0, _i = jobs.length; i < _i; i++) {
            jobs[i]();
        }
    }
};

export const R = function() {
    const args = [];

    const reactivity = new Reactivity(args);
    for(let i = 0, _i = arguments.length === 1 ? arguments.length : arguments.length - 1; i < _i; i++){
        const obj = arguments[i];
        if(typeof obj === 'function'){
            TaskManager.add(()=>{
                const objResolved = obj();
                objResolved.trigger = (val) => {
                    args[i] = val;
                    reactivity.emit();
                };
                args[i] = objResolved.value;
            })
        } else {

            obj.trigger = (val) => {
                args[i] = val;
                reactivity.emit();
            };
            args[i] = obj.value;
        }
    }

    if(arguments.length === 1){
        reactivity.fn = byPass;
    }else{
        reactivity.fn = arguments[arguments.length-1];
    }

    return reactivity;
};

export const Reactive = function(cfg){
    if(cfg === false) {
        return;
    }

    this.state = cfg ? Object.create(cfg) : {};
    this.subs = {};
};

Reactive.prototype = {
    state: {},
    subs: {},
    setters: {},

    fire: function (key, val, lastVal) {
        if (key in this.subs) {
            const subs = this.subs[key];
            for (let i = 0, _i = subs.length; i < _i; i++) {
                subs[i].call(this, this, val, lastVal);
            }
        }
    },

    on: function (key, fn) {
        let FN, obj;// TODO unAny
        if (arguments.length === 1) {
            obj = {
                value: key in this.state ? this.state[key] : void 0
            };
            FN = function (_, val, oldVal) {
                obj.value = val;
                obj.trigger && obj.trigger(val)
            };
        } else {
            FN = fn;
        }
        (this.subs[key] || (this.subs[key] = [])).push(FN);
        if (key in this.state)
            FN.call(this, this, this.state[key]);

        return obj;
    },
    set: function (obj) {
        for (let key in obj)
            this.setKey(key, obj[key]);
    },
    afterSetKey: function (key, val, lastVal) {
    },
    beforeSetKey: function (key, val, lastVal) {
        return val;
    },
    setKey: function (key, val) {
        const lastVal = this.state[key];
        if (lastVal === val)
            return null;
        if (val instanceof Reactivity) {
            val.scope = this;
            val.key = key;
            val.emit();
            return true;
        }

        val = this.beforeSetKey(key, val, lastVal);
        this.state[key] = val;

        if (key in this.setters) {
            if(typeof this.setters[key] === 'function'){
                this.setters[ key ].call( this, this, val, lastVal );
            }else{

            }
        } else {
            this.afterSetKey(key, val, lastVal);
        }

        this.fire(key, val, lastVal);
        return true;
    }
};

const Predefined = {
    input: {
        onChange: function() {
            this.set({checked: this.el.checked})
        }
    }
};

export const Component = function(tagName){
    // TODO supER
    Reactive.call(this);
    this.children = [];
    this.nodeName = tagName;
    if(tagName in Predefined){
        this.def = Predefined[tagName];
    }
};

Component.prototype = new Reactive();
Object.assign(Component.prototype, {
    nodeName: null,
    el: null,
    def: {},
    children: null,
    tree: null,
    setters: {
        dangerouslySetInnerHTML: (_, htmlText) => _.el.innerHTML = htmlText,
        text: (_, val) => _.el.innerText = val
    },

    render: function () {
        this.el = document.createElement(this.nodeName);
        return this;
    },
    init: function () {
        this.tree = this.render();
        this.el = this.tree.el;
        this.set(this.def);
    },
    renderTo: function (where) {
        where.appendChild(this.el);
    },
    addChild: function (child) {
        child.renderTo(this.el);
        this.children.push(child);
    },
    beforeSetKey: function (key, val, lastVal) {
        if (key.substr(0, 2) === 'on') {
            return (e) => {
                val.call(this, e)
            };
        } else {
            return val;
        }

    },

    afterSetKey: function (key, val, lastVal) {
        if (this.el) {
            if (key.substr(0, 2) === 'on') {
                const eventName = key.toLowerCase().substr(2);
                if (lastVal) {
                    this.el.removeEventListener(eventName, lastVal);
                }

                this.el.addEventListener(eventName, val);
            } else {
                //@ts-ignore
                this.el[key] = val;
                if (val === false) {
                    this.el.removeAttribute(key);
                } else {
                    this.el.setAttribute(key, val);
                }
            }
        }
    }
});
Component.extend = function(name, cfg) {

    const ctor = cfg.ctor || function() {
        Component.call(this);
    };
    ctor.prototype = new Component();
    const setters = Object.assign({}, ctor.prototype.setters, cfg.setters);

    Object.assign(ctor.prototype, cfg);
    ctor.prototype.setters = setters;
    ctor.extend = Component.extend;
    return ctor;
};
export const TextNode = Component.extend('TextNode', {
    setters: {
        value: (_, val)=>_.el.textContent = val
    },
    render: function(){
        this.el = document.createTextNode('');
        return this;
    },
    addChild: function (child) {
        throw new Error('No children in text node');
    }
});

export const h = function(ctor, props){
    let obj;
    if(typeof ctor==='string'){
        obj = new Component(ctor);
    }else {
        obj = new ctor();
    }
    obj.init();
    obj.set(props);
    for(let i = 2; i < arguments.length; i++) {
        const child = arguments[i];
        if(typeof child === 'string' || typeof child === 'number'){
            let textNode = new TextNode();
            textNode.init();
            textNode.set({value:child});
            obj.addChild(textNode);
        }else if(typeof child === 'function') {
            obj.addChild(child());
        }else{
            obj.addChild(child);
        }
    }
    return obj;
};



//export {Component, TextNode, h};