export type PropertySetterInterface<T> = (cmp: T, val: any, oldVal: any)=>any;
export type TreeType = {el: HTMLElement|Text,[key: string]: any};
export interface PropSettersInterface<T> {
    [key: string]: PropertySetterInterface<T>
}

/*
declare global {
    namespace JSX {
        interface IntrinsicElements {
            input: {
                type?: string;
                value?: any;
                disabled?: boolean
            };
            div: {className?: string}
            br: {}

        }
    }
    namespace Rjsx {
        R(byPass: Function):Component;

    }
}*/


const byPass = (a:any)=>a;

export class Reactivity {
    args: any[] = [];
    scope:any = null;
    key: string = null;
    fn: Function = null;
    constructor(args:any[]) {
        this.args = args;
    }
    emit() {
        this.scope.setKey(this.key, this.fn.apply(this.scope, this.args));
    }
}

export const TaskManager = {
    jobs: [] as Function[],
    active: false,
    add: function(task: Function) {
        TaskManager.jobs.push(task);
        if(!TaskManager.active) {
            TaskManager.active = true;
            requestAnimationFrame(TaskManager.work);
        }
    },
    work: function() {
        const jobs = TaskManager.jobs;
        TaskManager.jobs = [];
        TaskManager.active = false;

        for (let i = 0, _i = jobs.length; i < _i; i++) {
            jobs[i]();
        }
    }
};
interface ReactiveSubscriber {
    trigger?: Function;
    value: any;
}
type Aggregate = (...values: any[])=>any;
export function R (byPass: Function): Reactivity;
export function R (reactiveSubscriber1: ReactiveSubscriber, aggregate: Aggregate): Reactivity;
export function R (reactiveSubscriber1: ReactiveSubscriber, reactiveSubscriber2: ReactiveSubscriber, aggregate: Aggregate): Reactivity;
export function R (reactiveSubscriber1: ReactiveSubscriber, reactiveSubscriber2: ReactiveSubscriber, reactiveSubscriber3: ReactiveSubscriber, aggregate: Aggregate): Reactivity;
export function R (reactiveSubscriber1: ReactiveSubscriber, reactiveSubscriber2: ReactiveSubscriber, reactiveSubscriber3: ReactiveSubscriber, reactiveSubscriber4: ReactiveSubscriber, ...other: (Aggregate|ReactiveSubscriber)[]): Reactivity;
export function R ():Reactivity {
    const args: any[] = [];

    const reactivity = new Reactivity(args);
    for(let i = 0, _i = arguments.length === 1 ? arguments.length : arguments.length - 1; i < _i; i++){
        const obj: ReactiveSubscriber |  Function= arguments[i];
        if(typeof obj === 'function'){
            TaskManager.add(()=>{
                const objResolved = obj();
                objResolved.trigger = (val: any) => {
                    args[i] = val;
                    reactivity.emit();
                };
                args[i] = objResolved.value;
            })
        } else {

            obj.trigger = (val: any) => {
                args[i] = val;
                reactivity.emit();
            };
            args[i] = obj.value;
        }
    }

    if(arguments.length === 1){
        reactivity.fn = byPass;
    }else{
        reactivity.fn = arguments[arguments.length-1];
    }

    return reactivity;
};

class Reactive {
    state: any = {};
    subs: {[key: string]: Function[]} = {};
    setters: PropSettersInterface<Reactive> = {};
    constructor(cfg: object|false){
        if(cfg === false) {
            return;
        }

        this.state = cfg ? Object.create(cfg) : {};
        this.subs = {};
        // @ts-ignore
    }

    fire(key:string, val:any, lastVal:any){
        if(key in this.subs){
            const subs = this.subs[key];
            for(let i = 0, _i = subs.length; i < _i; i++){
                subs[i].call(this, this, val, lastVal);
            }
        }
    }
    on(key: string, fn?: PropertySetterInterface<Reactive>){
        let FN: PropertySetterInterface<Reactive>, obj: any;// TODO unAny
        if(arguments.length === 1) {
            obj = {
                value: key in this.state ? this.state[key] :void 0
            };
            FN = function(_, val, oldVal) {
                obj.value = val;
                obj.trigger && obj.trigger(val)
            };
        }else{
            FN = fn;
        }
        (this.subs[key] || (this.subs[key] = [])).push(FN);
        if(key in this.state)
            FN.call(this, this, this.state[key]);

        return obj;
    }
    set(obj: {[key: string]: any}){
        for(let key in obj)
            this.setKey(key, obj[key]);
    }
    afterSetKey(key: string, val: any, lastVal: any){}
    beforeSetKey(key: string, val: any, lastVal: any){return val;}
    setKey(key: string, val: any){
        const lastVal = this.state[key];
        if(lastVal === val)
            return null;
        if(val instanceof Reactivity){
            val.scope = this;
            val.key = key;
            val.emit();
            return true;
        }

        val = this.beforeSetKey(key, val, lastVal);
        this.state[key] = val;

        if(key in this.setters){
            this.setters[key].call(this, this, val, lastVal);
        }else {
            this.afterSetKey(key, val, lastVal);
        }

        this.fire(key, val, lastVal);
        return true;
    }
}

const Predefined: {[key: string]: any} = {
    input: {
        onChange: function() {
            this.set({checked: this.el.checked})
        }
    }
};
class Component<T> extends Reactive {
    nodeName: string = null;
    el: HTMLElement|Text|any = null;
    def = {};
    children: Component<any>[] = null;
    tree: Component<any> = null;
    setters: PropSettersInterface<Component<T>> = {
        dangerouslySetInnerHTML: (_, htmlText) => _.el.innerHTML = htmlText,
        text: (_, val) => _.el.innerText = val
    };

    render(): Component<any>{
        this.el = document.createElement(this.nodeName);
        return this;
    }
    constructor(tagName: string){
        super({});
        this.children = [];
        this.nodeName = tagName;
        if(tagName in Predefined){
            this.def = Predefined[tagName];
        }
    }
    init(){
        this.tree = this.render();
        this.el = this.tree.el as HTMLElement;
        this.set(this.def);
    }
    renderTo(where: HTMLElement) {
        where.appendChild(this.el);
    }
    addChild(child: Component<any>) {
        child.renderTo(this.el);
        this.children.push(child);
    }
    beforeSetKey(key: string, val: any, lastVal: any): any {
        if (key.substr(0, 2) === 'on') {
            return (e: any)=>{val.call(this, e)};
        }else{
            return val;
        }

    }

    afterSetKey(key: string, val: any, lastVal: any){
        if(this.el){
            if (key.substr(0, 2) === 'on') {
                const eventName = key.toLowerCase().substr(2);
                if (lastVal) {
                    this.el.removeEventListener(eventName, lastVal);
                }

                this.el.addEventListener(eventName, val);
            } else {
                //@ts-ignore
                this.el[key]  = val;
                if (val === false) {
                    this.el.removeAttribute(key);
                } else {
                    this.el.setAttribute(key, val);
                }
            }
        }
    }
}

interface TextNodeProps {
    value: string
}

class TextNode extends Component<TextNodeProps> {
    constructor(){
        super('TextNode');
    }
    setters: PropSettersInterface<TextNode> = {
        value: (_, val)=>_.el.textContent = val
    };
    render(){
        this.el = document.createTextNode('') as Text;
        return this;
    }
    addChild (child: any) {
        throw new Error('No children in text node');
    }
}
TextNode.prototype.setters = { value: (_, val)=>_.el.textContent = val};



const h = function(ctor: string|Function, props: any){
    let obj;
    if(typeof ctor==='string'){
        obj = new Component(ctor);
    }else {
        //@ts-ignore
        obj = new (ctor as Function)();
    }
    obj.init();
    obj.set(props);
    for(let i = 2; i < arguments.length; i++) {
        const child = arguments[i];
        if(typeof child === 'string' || typeof child === 'number'){
            let textNode = new TextNode();
            textNode.init();
            textNode.set({value:child});
            obj.addChild(textNode);
        }else if(typeof child === 'function') {
            obj.addChild(child());
        }else{
            obj.addChild(child);
        }
    }
    return obj;
};



export {Component, TextNode, h};