import {PropertySetterInterface, PropSettersInterface} from "./Rjsx";

const byPass = a => a;
const emptyFn = ()=>void 0;
const falseFn = ()=>false;

const REFLECTION = true;
const WEAKMAP = typeof WeakMap === 'function';
if(typeof Object.assign === 'undefined'){
    Object.assign = function(a,...x) {
        let i, _i = x.length, o, key;
        for(i = 0; i< _i; i++){
            o = x[i];
            for(key in o){
                a[key] = o[key];
            }
        }
        return a;
    };
}
const rand = ()=>Math.random().toString(36).substr(2);
const WeakMapShim = function() {
    this._id = '__'+rand();
    this.store = {};
    this.damaged = [];
};

WeakMapShim.prototype = {
    get: function(a) {
        return this.store[a[this._id]];
    },
    has: function(a) {
        return a.hasOwnProperty(this._id) && this.store.hasOwnProperty(a[this._id]);
    },
    set: function(a,b) {
        let key = rand();
        a[this._id] = key;
        this.store[key] = b;
        this.damaged.push(a);
    },
    clear: function() {
        this.damaged.forEach((item)=>delete item[this._id]);
        this.damaged = [];
        this.store = {};
    }
};
export const Reactivity = function(args) {
    this.args = args;
};

const Sub = function(obj, key) {
    this.value = obj.get(key);
    if(REFLECTION){
        this.key = key;
        this.obj = obj;
    }
    this.FN = this.FN.bind(this);
};
Sub.prototype = {
    value: void 0,
    trigger: emptyFn,
    key: '',
    obj: null,
    FN: function (_, val, oldVal) {
        this.value = val;
        this.trigger && this.trigger(val);
    },
    '~destroy': function() {
        this.obj.unsub(this.key, this.FN);
    }
};

Reactivity.prototype = {
    _deps: [],
    args: [],
    scope: null,
    key: null,
    fn: null,
    emit: function() {
        TaskManager.add(()=>{
            this.scope._setKey(this.key, 0, this.fn.apply(this.scope, this.args), this.scope.state, this.scope.setters);
        });
    },
    '~destroy': function() {
        let deps = this._deps, i = 0, _i = deps.length;
        for(;i<_i;i++){
            deps[i]['~destroy']();
        }
    }
};
if(REFLECTION){
    Reactivity.prototype._deps = [];
}

let jobSwap = [];
const Task = function(fn, scope) {
    this.fn = fn;
    this.scope = scope;
};
export const TaskManager = {
    jobs: [],
    active: false,
    add: function(taskFn, scope) {
        TaskManager.jobs.push(new Task(taskFn, scope));
        if(!TaskManager.active) {
            TaskManager.active = true;
            requestAnimationFrame(TaskManager.work);
        }
    },
    work: function() {
        const jobs = TaskManager.jobs;
        TaskManager.jobs = jobSwap;
        jobSwap.length = 0;
        jobSwap = jobs;
        TaskManager.active = false;

        let i, _i, job;
        for (i = 0, _i = jobs.length; i < _i; i++) {
            job = jobs[i];
            job.fn.call(job.scope);
        }
    }
};

export const R = function() {
    const args = [];

    const reactivity = new Reactivity(args);
    if(REFLECTION){
        reactivity._deps = [];
    }
    for(let i = 0, _i = arguments.length === 1 ? arguments.length : arguments.length - 1; i < _i; i++){
        const obj = arguments[i];
        if(typeof obj === 'function'){
            TaskManager.add(()=>{
                const objResolved = obj();
                objResolved.trigger = (val) => {
                    args[i] = val;
                    reactivity.emit();
                };
                args[i] = objResolved.value;
                if(REFLECTION){
                    reactivity._deps[i] = objResolved;
                }
            })
        } else {

            obj.trigger = (val) => {
                args[i] = val;
                reactivity.emit();
            };
            args[i] = obj.value;
            if(REFLECTION){
                reactivity._deps[i] = obj;
            }
        }
    }

    if(arguments.length === 1){
        reactivity.fn = byPass;
    }else{
        reactivity.fn = arguments[arguments.length-1];
    }

    return reactivity;
};
export const ReactiveContent = function(parent, reactivity) {
    reactivity.scope = this;
    reactivity.key = 'content';
    this.parent = parent;
    this.reactivity = reactivity;
};
ReactiveContent.prototype = {
    _setKey: function(key, keyCursor, val, state, setters) {
        const children = this.parent.children;
        const index = children.indexOf(this);

        if(index>-1){
            let i, _i = children.length, child, childInserted = false;

            for( i = index + 1; i < _i; i++ ){
                child = children[i];
                if(child instanceof Component){
                    child.el.parentNode.insertBefore(val.el, child.el);
                    childInserted = true;
                    break;
                }
            }

            // TODO other cases!

        }else{
            throw new Error('Fix it. My parent does not contain me (ReactiveChild)');
        }
    },
    clone: function(parent) {
        return new ReactiveContent(parent, this.reactivity);
    }
};

export const clone = function(what, where, transformator){
    let key, val;
    let proxy = transformator || falseFn;
    let transformed;
    for(key in what){
        val = what[key];
        if(typeof val === 'object'){
            transformed = proxy(val);

            if(transformed === false){
                if(Array.isArray(val)){
                    if(!(key in where))
                        where[key] = [];
                }else{
                    if(!(key in where))
                        where[key] = {};
                }
                clone(val, where[key], transformator);
            }else{
                where[key] = transformed;
            }
        }else{
            where[key] = val;
        }
    }
    return where;
};
const walk = function(obj, fn) {
    clone(obj, {}, fn);
};
export const Reactive = function(cfg){

    if(cfg === false) {
        return;
    }
    if(REFLECTION){
        this._rState = {};
    }else{
        this._r = [];
    }
    this.state = cfg ? Object.create(cfg) : {};
    this.subs = {};
};

Reactive.prototype = {
    state: {},
    _rState: {},
    _r: [],
    subs: {},
    setters: {},

    fire: function (key, val, lastVal) {
        if (key in this.subs) {
            const subs = this.subs[key];
            for (let i = 0, _i = subs.length; i < _i; i++) {
                subs[i].call(this, this, val, lastVal);
            }
        }
    },

    sub: function (key) {
        let obj = new Sub(this, key);

        (this.subs[key] || (this.subs[key] = [])).push(obj.FN);
        if (this.has(key))
            obj.FN.call(this, this, this.get(key));

        return obj;
    },

    unsub: function(key, fn) {
        const index = this.subs[key].indexOf(fn);
        if(index === -1){
            throw new Error('Already unsubscribed');
        }else{
            this.subs[key].splice(index, 1);
        }
    },

    get: function(key) {
        let ptr = this.state,
            tokens = key.split('.'),
            i = 0, _i = tokens.length;
        for(;i<_i;i++){
            ptr = ptr[tokens[i]];
            if(ptr === void 0)
                return;
        }
        return ptr;
    },
    has: function(key) {
        // TODO rewrite recursive
        return key in this.state;
    },
    set: function (obj, statePtr, settersPtr) {
        let state, setters, key;

        if(statePtr === void 0){
            state = this.state;
            setters = this.setters;
        }else{
            state = statePtr;
            setters = settersPtr;
        }

        for (key in obj)
            this._setKey(key.split('.'), 0, obj[key], state, setters);
    },
    afterSetKey: function (key, val, lastVal) {
    },
    beforeSetKey: function (key, val, lastVal) {
        return val;
    },
    _getReflectiveState: function(cloningWorld) {
        const cloningState = {};
        clone(this.state, cloningState, function(val) {
            if(val instanceof Component){
                // serialize
                return val;
            }
            return false;
        });

        clone(this._rState, cloningState, function(val) {
            if(val instanceof Reactivity){
                var args = val._deps.map(function(dep){
                    if(!cloningWorld.has(dep.obj)){
                        cloningWorld.set(dep.obj, new dep.obj._ctor(dep.obj.nodeName));
                    }
                    return cloningWorld.get(dep.obj).sub(dep.key);
                }).concat(val.fn);
                console.log(val, args)

                return R.apply(this, args);
            }

            return false;
        });

        return cloningState;


    },
    _storeReactivity: function(r) {
        if(REFLECTION){
            let pointer = this._rState,
                key = r.key,
                subKey,
                i = 0, _i = key.length - 1;

            for(;i<_i; i++){
                subKey = key[i];
                pointer = pointer[subKey] || (pointer[subKey] = {});
            }
            pointer[key[i]] = r;//{from: r._deps, to: {obj: r.scope, key: r.key}, fn: r.fn};
        }else{
            this._r.push(r);
        }
    },
    _setKey: function (key, keyCursor, val, state, setters) {

        let valueKey;

        const theKey = key[keyCursor];
        let lastVal = state[theKey];



        const isObjectVal = typeof val === 'object';
        if (lastVal === val && !isObjectVal){
            return null;
        }

        if (val instanceof Reactivity) {
            val.scope = this;
            val.key = key;
            val.emit();
            this._storeReactivity(val);
            return true;
        }

        let keyInSetters = theKey in setters, setterIsFn = false;
        if(keyInSetters){
            setterIsFn = typeof setters[theKey] === 'function';
        }


        if(key.length>keyCursor+1){
            // Deeper
            if(typeof state[theKey] !== 'object'){
                state[theKey] = lastVal = {};
            }
            if (!(keyInSetters) || !(setterIsFn)){
                return this._setKey( key, keyCursor + 1, val, lastVal, setters[ theKey ] || {} );
            }else if(setterIsFn){
                let i, _i,
                    newVal = {},
                    newValPtr = newVal,
                    subKey;

                for(i = 1, _i = key.length-1; i < _i; i++){
                    subKey = key[i];
                    newValPtr[subKey] = {};
                }
                newValPtr[key[i]] = val;
                val = newVal;
            }
        }

        val = this.beforeSetKey(theKey, val, lastVal);

        let shouldSetVal = true;

        const isComponent = val instanceof Component,
            wasComponent = lastVal instanceof Component;
        if(!(isComponent) && wasComponent){
            lastVal.set(val);
            return false;
        }
        if(isComponent && wasComponent){
            lastVal['~destroy']();
        }

        if (keyInSetters) {
            if(setterIsFn){
                shouldSetVal = false !== setters[ theKey ].call( this, this, val, lastVal, theKey, state );
                if(shouldSetVal !== false){
                    state[ theKey ] = val;
                }
            }else{
                state[theKey] = val;
                if(isObjectVal){
                    if(typeof lastVal !== 'object'){
                        state[theKey] = lastVal = {};
                    }

                    // TODO if lastVal is not reactive => make it
                    for (valueKey in val){
                        this._setKey(key.concat(valueKey), keyCursor + 1, val[valueKey], lastVal, setters[theKey] || {})
                    }
                    return true;
                }
            }
        } else {
            state[theKey] = val;
            this.afterSetKey(theKey, val, lastVal);
        }
        if(shouldSetVal){
            this.fire( theKey, val, lastVal );
        }
        return true;
    },
    '~destroy': function() {
        if(REFLECTION){
            walk(this._rState, function(val) {
                if(val instanceof Reactivity){
                    val['~destroy']();
                    return true;
                }else{
                    return false;
                }
            });
        }
    }
};

const Predefined = {
    input: {
        onChange: function() {
            this.set({checked: this.el.checked})
        }
    }
};

export const Component = function(tagName){
    // TODO supER
    Reactive.call(this);
    this.children = [];
    this.nodeName = tagName;
    if(tagName in Predefined){
        this.def = Predefined[tagName];
    }
    this._laters = {};
};

const NumberIsPx = function(_, style, prop, val) {
    //console.log(prop, val)
    if(typeof val === 'number'){
        style[prop] = val +'px';
    }else{
        style[prop] = val;
    }
};
const emptyObj = {};
const styleSetters = {
    width: NumberIsPx,
    height: NumberIsPx,
    left: NumberIsPx,
    top: NumberIsPx,
    bottom: NumberIsPx,
    right: NumberIsPx
};
Component.prototype = new Reactive();
Object.assign(Component.prototype, {
    _ctor: Component,
    _laterTrigger: false,
    later: function(name, fn) {
        if(!(name in this._laters)){
            this._laters[name] = fn;
        }
        if(!this._laterTrigger){
            TaskManager.add(this.laterProcessor, this);
            this._laterTrigger = true;
        }
    },
    laterProcessor: function() {
        let taskName, _laters = this._laters;
        this._laterTrigger = false;
        this._laters = {};

        for(taskName in _laters){
            _laters[taskName].call(this)
        }

    },

    nodeName: null,
    el: null,
    def: {},
    children: null,
    tree: null,
    inDOM: false,
    setters: {
        dangerouslySetInnerHTML: (_, htmlText) => _.el.innerHTML = htmlText,
        text: (_, val) => _.el.innerText = val,
        style: (_, val, lastVal, theKey, state)=>{
            if(state.style === void 0){
                state.style = {};
            }

            var style = _.el.style,
            lastStyle = lastVal || emptyObj;

            for(var i in val){
                //console.log(i, val[i])
                if(val[i] instanceof Reactivity){
                    val[i].scope = _;
                    val[i].key = ['style', i];
                    val[i].emit();
                    _._storeReactivity(val[i]);
                    continue;
                }

                if(lastStyle[i] !== val[i]){
                    state.style[i] = val[i];
                    if( i in styleSetters ){
                        styleSetters[ i ].call( _, _, style, i, val[ i ] )
                    }else{
                        style[ i ] = val[ i ];
                    }
                }

            }

            // manual assign
            return false;
        }
    },

    render: function () {
        this.el = document.createElement(this.nodeName);
        return this;
    },

    // become true after init function is finished
    _inited: false,
    init: function () {
        this.tree = this.render();
        this.el = this.tree.el;

        this.set(this.def);
        this._inited = true;
    },
    clone: function(cloningWorld) {

        if(cloningWorld === void 0){
            if(WEAKMAP){
                cloningWorld = new WeakMap();
            }else{
                cloningWorld = new WeakMapShim();
            }
        }

        // CLONE OBJECT
        let clone;
        if(cloningWorld.has(this)){
            clone = cloningWorld.get(this);
        }else{
            clone = new this._ctor(this.nodeName);
            cloningWorld.set(this, clone);
        }



        clone.init();

        // CLONE STRUCTURE
        this.children.forEach(function(child) {
            if(child instanceof ReactiveContent){
                clone.addChild(child.reactivity);
            }else{
                clone.addChild(child.clone(cloningWorld));
            }
        });
        //TaskManager.add(function() {
            // CLONE STATE
            clone._inited = false;
            if(REFLECTION){
                clone.set( this._getReflectiveState(cloningWorld) );
            }else{
                clone.set(this.state);
            }
            clone._inited = true;
        //});
        return clone;
    },
    renderTo: function (where) {
        where.appendChild(this.el);
    },
    mount: function(el) {
        this.renderTo(el);
        this.inDOM = true;
        this._updateChildrenSize();

        window.addEventListener('resize', ()=>{
            this.later('resize', this._updateChildrenSize);
        });
    },
    _updateChildrenSize: function() {
        if(this.inDOM){
            for( let i = 0, _i = this.children.length; i < _i; i++ ){
                const child = this.children[ i ];
                child._updateSize();
            }
        }
    },
    addChild: function (child) {
        if(child instanceof Reactivity){

            this.children.push( new ReactiveContent(this, child) );

            /*val.scope = this;
            val.key = key;*/
            //debugger
        }else{
            child.renderTo( this.el );
            this.children.push( child );
            if( this.inDOM ){
                child._updateSize();
            }
        }
    },
    _updateSize: function() {
        const rect = this.getBoundingClientRect();
        if( rect ){
            this.set( { width: rect.width, height: rect.height } );
        }
    },
    beforeSetKey: function (key, val, lastVal) {
        if (key.substr(0, 2) === 'on') {
            return (e) => {
                val.call(this, e)
            };
        } else {

            if(val instanceof Component && !this._inited){
                // magically defined subcomponents
                return val.clone();
            }else{
                return val;
            }
        }

    },

    afterSetKey: function (key, val, lastVal) {
        if (this.el) {
            if (key.substr(0, 2) === 'on') {
                //console.log(key)
                const eventName = key.toLowerCase().substr(2);
                if (lastVal) {
                    this.un(eventName, lastVal);
                }
                this.on(eventName, val);

            } else {
                //@ts-ignore
                this.el[key] = val;
                if (val === false) {
                    this.el.removeAttribute(key);
                } else {
                    this.el.setAttribute(key, val);
                }
            }
        }
    },

    getBoundingClientRect: function() {
        return this.el.getBoundingClientRect();
    },

    on: function(eventName, fn) {
        this.el.addEventListener(eventName, fn);
    },
    un: function(eventName, fn) {
        this.el.removeEventListener(eventName, fn);
    },
    once: function(eventName, fn) {
        const wrap = () => {
            fn.apply(this, arguments);
            this.un(eventName, wrap);
        };
        this.on(eventName, wrap);
    }
});

Component._morphFnsSugar = function(cfg) {
    const res = {};
    let key, tokens, i, _i;
    for(key in cfg){
        if(key.indexOf(',')>-1){
            tokens = key.split(',');
            for( i = 0, _i = tokens.length; i < _i; i++){
                res[tokens[i]] = cfg[key]
            }
        }else{
            res[key] = cfg[key];
        }
    }

    return res;
};

Component.extend = function(name, cfg) {

    const ctor = cfg.ctor || function() {
        Component.call(this);
    };
    ctor.prototype = new Component();

    const setters = Object.assign(
        {},
        ctor.prototype.setters,
        Component._morphFnsSugar(cfg.setters)
    );
    ctor.prototype.type = name;

    Object.assign(ctor.prototype, cfg);

    ctor.prototype._ctor = ctor;
    ctor.prototype.setters = setters;
    ctor.extend = Component.extend;
    return ctor;
};

export const TextNode = Component.extend('TextNode', {
    setters: {
        value: (_, val)=>_.el.textContent = val
    },
    render: function(){
        this.el = document.createTextNode('');
        return this;
    },
    addChild: function (child) {
        throw new Error('No children in text node');
    },
    afterSetKey: emptyFn,
    getBoundingClientRect: ()=> null
});
const doc = new Component();
if(typeof document !== 'undefined'){
    doc.el = document;
}
Component.prototype.doc = doc;

export const h = function(ctor, props){
    let obj;
    if(typeof ctor==='string'){
        obj = new Component(ctor);
    }else {
        obj = new ctor();
    }
    obj.init();
    obj.set(props);
    for(let i = 2; i < arguments.length; i++) {
        const child = arguments[i];
        if(typeof child === 'string' || typeof child === 'number'){
            let textNode = new TextNode();
            textNode.init();
            textNode.set({value:child});
            obj.addChild(textNode);
        }else if(typeof child === 'function') {
            obj.addChild(child());
        }else{
            obj.addChild(child);
        }
    }
    return obj;
};



//export {Component, TextNode, h};