"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/*
declare global {
    namespace JSX {
        interface IntrinsicElements {
            input: {
                type?: string;
                value?: any;
                disabled?: boolean
            };
            div: {className?: string}
            br: {}

        }
    }
    namespace Rjsx {
        R(byPass: Function):Component;

    }
}*/
var byPass = function (a) { return a; };
var Reactivity = /** @class */ (function () {
    function Reactivity(args) {
        this.args = [];
        this.scope = null;
        this.key = null;
        this.fn = null;
        this.args = args;
    }
    Reactivity.prototype.emit = function () {
        this.scope.setKey(this.key, this.fn.apply(this.scope, this.args));
    };
    return Reactivity;
}());
exports.Reactivity = Reactivity;
exports.TaskManager = {
    jobs: [],
    active: false,
    add: function (task) {
        exports.TaskManager.jobs.push(task);
        if (!exports.TaskManager.active) {
            exports.TaskManager.active = true;
            requestAnimationFrame(exports.TaskManager.work);
        }
    },
    work: function () {
        var jobs = exports.TaskManager.jobs;
        exports.TaskManager.jobs = [];
        exports.TaskManager.active = false;
        for (var i = 0, _i = jobs.length; i < _i; i++) {
            jobs[i]();
        }
    }
};
function R() {
    var args = [];
    var reactivity = new Reactivity(args);
    var _loop_1 = function (i, _i) {
        var obj = arguments_1[i];
        if (typeof obj === 'function') {
            exports.TaskManager.add(function () {
                var objResolved = obj();
                objResolved.trigger = function (val) {
                    args[i] = val;
                    reactivity.emit();
                };
                args[i] = objResolved.value;
            });
        }
        else {
            obj.trigger = function (val) {
                args[i] = val;
                reactivity.emit();
            };
            args[i] = obj.value;
        }
    };
    var arguments_1 = arguments;
    for (var i = 0, _i = arguments.length === 1 ? arguments.length : arguments.length - 1; i < _i; i++) {
        _loop_1(i, _i);
    }
    if (arguments.length === 1) {
        reactivity.fn = byPass;
    }
    else {
        reactivity.fn = arguments[arguments.length - 1];
    }
    return reactivity;
}
exports.R = R;
;
var Reactive = /** @class */ (function () {
    function Reactive(cfg) {
        this.state = {};
        this.subs = {};
        this.setters = {};
        if (cfg === false) {
            return;
        }
        this.state = cfg ? Object.create(cfg) : {};
        this.subs = {};
        // @ts-ignore
    }
    Reactive.prototype.fire = function (key, val, lastVal) {
        if (key in this.subs) {
            var subs = this.subs[key];
            for (var i = 0, _i = subs.length; i < _i; i++) {
                subs[i].call(this, this, val, lastVal);
            }
        }
    };
    Reactive.prototype.on = function (key, fn) {
        var FN, obj; // TODO unAny
        if (arguments.length === 1) {
            obj = {
                value: key in this.state ? this.state[key] : void 0
            };
            FN = function (_, val, oldVal) {
                obj.value = val;
                obj.trigger && obj.trigger(val);
            };
        }
        else {
            FN = fn;
        }
        (this.subs[key] || (this.subs[key] = [])).push(FN);
        if (key in this.state)
            FN.call(this, this, this.state[key]);
        return obj;
    };
    Reactive.prototype.set = function (obj) {
        for (var key in obj)
            this.setKey(key, obj[key]);
    };
    Reactive.prototype.afterSetKey = function (key, val, lastVal) { };
    Reactive.prototype.beforeSetKey = function (key, val, lastVal) { return val; };
    Reactive.prototype.setKey = function (key, val) {
        var lastVal = this.state[key];
        if (lastVal === val)
            return null;
        if (val instanceof Reactivity) {
            val.scope = this;
            val.key = key;
            val.emit();
            return true;
        }
        val = this.beforeSetKey(key, val, lastVal);
        this.state[key] = val;
        if (key in this.setters) {
            this.setters[key].call(this, this, val, lastVal);
        }
        else {
            this.afterSetKey(key, val, lastVal);
        }
        this.fire(key, val, lastVal);
        return true;
    };
    return Reactive;
}());
var Predefined = {
    input: {
        onChange: function () {
            this.set({ checked: this.el.checked });
        }
    }
};
var Component = /** @class */ (function (_super) {
    __extends(Component, _super);
    function Component(tagName) {
        var _this = _super.call(this, {}) || this;
        _this.nodeName = null;
        _this.el = null;
        _this.def = {};
        _this.children = null;
        _this.tree = null;
        _this.setters = {
            dangerouslySetInnerHTML: function (_, htmlText) { return _.el.innerHTML = htmlText; },
            text: function (_, val) { return _.el.innerText = val; }
        };
        _this.children = [];
        _this.nodeName = tagName;
        if (tagName in Predefined) {
            _this.def = Predefined[tagName];
        }
        return _this;
    }
    Component.prototype.render = function () {
        this.el = document.createElement(this.nodeName);
        return this;
    };
    Component.prototype.init = function () {
        this.tree = this.render();
        this.el = this.tree.el;
        this.set(this.def);
    };
    Component.prototype.renderTo = function (where) {
        where.appendChild(this.el);
    };
    Component.prototype.addChild = function (child) {
        child.renderTo(this.el);
        this.children.push(child);
    };
    Component.prototype.beforeSetKey = function (key, val, lastVal) {
        var _this = this;
        if (key.substr(0, 2) === 'on') {
            return function (e) { val.call(_this, e); };
        }
        else {
            return val;
        }
    };
    Component.prototype.afterSetKey = function (key, val, lastVal) {
        if (this.el) {
            if (key.substr(0, 2) === 'on') {
                var eventName = key.toLowerCase().substr(2);
                if (lastVal) {
                    this.el.removeEventListener(eventName, lastVal);
                }
                this.el.addEventListener(eventName, val);
            }
            else {
                //@ts-ignore
                this.el[key] = val;
                if (val === false) {
                    this.el.removeAttribute(key);
                }
                else {
                    this.el.setAttribute(key, val);
                }
            }
        }
    };
    return Component;
}(Reactive));
exports.Component = Component;
var TextNode = /** @class */ (function (_super) {
    __extends(TextNode, _super);
    function TextNode() {
        var _this = _super.call(this, 'TextNode') || this;
        _this.setters = {
            value: function (_, val) { return _.el.textContent = val; }
        };
        return _this;
    }
    TextNode.prototype.render = function () {
        this.el = document.createTextNode('');
        return this;
    };
    TextNode.prototype.addChild = function (child) {
        throw new Error('No children in text node');
    };
    return TextNode;
}(Component));
exports.TextNode = TextNode;
TextNode.prototype.setters = { value: function (_, val) { return _.el.textContent = val; } };
var h = function (ctor, props) {
    var obj;
    if (typeof ctor === 'string') {
        obj = new Component(ctor);
    }
    else {
        //@ts-ignore
        obj = new ctor();
    }
    obj.init();
    obj.set(props);
    for (var i = 2; i < arguments.length; i++) {
        var child = arguments[i];
        if (typeof child === 'string' || typeof child === 'number') {
            var textNode = new TextNode();
            textNode.init();
            textNode.set({ value: child });
            obj.addChild(textNode);
        }
        else if (typeof child === 'function') {
            obj.addChild(child());
        }
        else {
            obj.addChild(child);
        }
    }
    return obj;
};
exports.h = h;
//# sourceMappingURL=Rjsx.js.map